package com.amity.socialcloud.sdk.social.data.community.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.dto.community.JoinRequestQueryDto
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestPersister
import com.amity.socialcloud.sdk.social.data.community.CommunityRemoteDataStore
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

class CommunityJoinRequestQueryMediator(
    private val communityId: String,
    private val status: String,
    private val sortBy: AmityCommunitySortOption? = null,
    private val targetType: String,
    private val type: String,
) : QueryStreamMediator<JoinRequestEntity, JoinRequestQueryDto>(
    nonce = AmityNonce.JOIN_REQUEST_LIST,
    queryStreamKeyCreator = CommunityJoinRequestKeyCreator(
        communityId,
        status,
        sortBy,
        targetType,
        type
    ),
) {

    override fun getFirstPageRequest(pageSize: Int): Single<JoinRequestQueryDto> {
        return getRequest(limit = pageSize)
    }

    override fun getFetchByTokenRequest(token: String): Single<JoinRequestQueryDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: JoinRequestQueryDto): Completable {
        return CommunityJoinRequestPersister().persist(dto = dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: JoinRequestQueryDto): QueryStreamQueryToken {
        return QueryStreamQueryToken(
            queryStreamKeyCreator = CommunityJoinRequestKeyCreator(
                communityId,
                status,
                sortBy,
                targetType,
                type
            ),
            next = dto.paging?.next,
            previous = dto.paging?.previous,
            primaryKeys = dto.joinRequests?.map { item -> item.joinRequestId ?: "" } ?: listOf()
        )
    }

    override fun forceRefresh(): Boolean = true

    private fun getRequest(
        limit: Int? = null,
        token: String? = null,
    ): Single<JoinRequestQueryDto> {
        return CommunityRemoteDataStore().getJoinRequest(
            communityId = communityId,
            status = status,
            sortBy = sortBy?.name,
            targetType = targetType,
            type = type,
            limit = limit,
            token = token,
        ).toRx2()
    }

}