package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.model.core.events.AmityCommunityEvents
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import io.reactivex.rxjava3.core.Single

internal class CommunityTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(community: AmityCommunity, events: AmityCommunityEvents) : Single<String> {
        val topic = when (events) {
            AmityCommunityEvents.COMMUNITY -> {
                community.path
            }
            AmityCommunityEvents.POSTS -> {
                community.path + "/post/+"
            }
            AmityCommunityEvents.COMMENTS -> {
                community.path + "/post/+/comment/+"
            }
            AmityCommunityEvents.POSTS_AND_COMMENTS -> {
                community.path + "/post/#"
            }
            AmityCommunityEvents.STORIES_AND_COMMENTS -> {
                community.path + "/story/#"
            }
        }
        //AmityLog.tag("CommunityTopicGenUC").i( "generated topic: " + topic)
        return Single.just(topic)
    }

}