package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.ekoapp.ekosdk.internal.api.dto.EventDto
import org.joda.time.DateTime

internal class EventEntityMapper : EntityMapper<EventDto, EventEntity>() {

    override fun map(list: List<EventDto>): List<EventEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EventDto): EventEntity {
        return EventEntity().apply {
            publicId = dto.publicId ?: ""
            eventId = dto.eventId ?: ""
            title = dto.title ?: ""
            description = dto.description ?: ""
            type = dto.type ?: "unknown"
            status = dto.status ?: "unknown"
            startTime = dto.startTime ?: DateTime.now()
            endTime = dto.endTime
            coverImageFileId = dto.coverImageFileId
            originType = dto.originType ?: ""
            originId = dto.originId ?: ""
            userId = dto.userId ?: ""
            discussionCommunityId = dto.discussionCommunityId
            targetCommunityId = if (dto.originType == "community") dto.originId else null
            postId = dto.postId
            rsvpCount = dto.rsvpCount ?: 0
            interestedCount = dto.interestedCount ?: 0
            isLocationVisible = dto.isLocationVisible ?: false
            location = dto.location
            externalUrl = dto.externalUrl
            metadata = dto.metadata
            path = dto.path ?: ""
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
        }
    }
}
