package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ResolveChannelUnreadInfoUseCase
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.ObjectResolverEngine
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

internal class ChannelJoined : ChannelEventListener() {

    override fun getEventName(): String {
        return "channel.joined"
    }

    override fun shouldProcessEvent(dto: ChannelEventDto): Boolean {
        return true
    }
    
    override fun processEvent(dto: ChannelEventDto) {
        super.processEvent(dto)
        MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
        dto.channelDtoList
            .map { it.channelId }
            .let(ResolveChannelUnreadInfoUseCase()::execute)
    }

}