package com.amity.socialcloud.sdk.core.session.eventbus

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.LogoutProcessState
import com.amity.socialcloud.sdk.core.session.model.AppEvent
import io.reactivex.rxjava3.core.BackpressureStrategy
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers
import io.reactivex.rxjava3.subjects.PublishSubject

class AppEventBus {

    private val eventPublisher: PublishSubject<AppEvent> = PublishSubject.create()


    fun observe(): Flowable<AppEvent> {
        return eventPublisher.toFlowable(BackpressureStrategy.BUFFER)
            .distinctUntilChanged()
            .subscribeOn(Schedulers.io())
    }

    fun publish(appEvent: AppEvent) {
        if(appEvent ==AppEvent.ManualLogout) {
            CoreClient.logoutProcessState = LogoutProcessState.LOGGING_OUT
        }
        eventPublisher.onNext(appEvent)
    }
}