package com.amity.socialcloud.sdk.api.core.presence

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.model.core.presence.AmityOnlineUsersSnapshot
import com.amity.socialcloud.sdk.model.core.presence.AmityUserPresence
import com.ekoapp.ekosdk.internal.usecase.presence.GetOnlineUsersCountUseCase
import com.ekoapp.ekosdk.internal.usecase.presence.GetRoomOnlineUsersCountUseCase
import com.ekoapp.ekosdk.internal.usecase.presence.GetUserPresencesUseCase
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single
import java.util.concurrent.TimeUnit

class AmityUserPresenceRepository internal constructor() {

    private val presenceSyncEngine
        get() = CoreClient.presenceSyncEngine

    /* begin_public_function
      id: user.presence.get_user_presence
    */
    fun getUserPresence(userIds: List<String>): Single<List<AmityUserPresence>> {
        return GetUserPresencesUseCase().execute(userIds)
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.sync_user_presence
   */
    fun syncUserPresence(userId: String, viewId: String = "amity-global") {
        presenceSyncEngine?.syncUserPresence(userId, viewId)
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.unsync_user_presence
   */
    fun unsyncUserPresence(userId: String, viewId: String = "amity-global") {
        presenceSyncEngine?.unsyncUserPresence(userId, viewId)
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.unsync_all_user_presence
   */
    fun unsyncAllUserPresence() {
        presenceSyncEngine?.unsyncAllUserPresence()
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.get_syncing_user_presence
   */
    fun getSyncingUserPresence(): Flowable<List<AmityUserPresence>> {
        return presenceSyncEngine?.getSyncingUserPresence() ?: Flowable.empty()
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.get_online_users_count
   */
    fun getOnlineUsersSnapshot(): Single<AmityOnlineUsersSnapshot> {
        return AmityOnlineUsersSnapshot.create()
    }
    /* end_public_function */

    /* begin_public_function
     id: user.presence.get_online_users_snapshot
   */
    fun getOnlineUsersCount(): Single<Int> {
        return GetOnlineUsersCountUseCase().execute()
    }
    /* end_public_function */
}