package com.ekoapp.ekosdk.internal.init

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.amity.socialcloud.sdk.log.AmityLog
import org.joda.time.DateTimeZone
import java.util.*

class TimeZoneChangedReceiver : BroadcastReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        val tzId = intent.getStringExtra("time-zone")
        try {
            val newDefault = DateTimeZone.forTimeZone(TimeZone.getDefault())
            DateTimeZone.setDefault(newDefault)
            AmityLog.tag(TimeZoneChangedReceiver::class.java.name).d("TIMEZONE_CHANGED received, changed default timezone to \"$tzId\"")
        } catch (e: IllegalArgumentException) {
            AmityLog.tag(TimeZoneChangedReceiver::class.java.name).e(e, "Could not recognize timezone id \"$tzId\"")
        }
    }
}
