package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import androidx.room.OnConflictStrategy;

import com.ekoapp.ekosdk.CategoryEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryObject;
import com.google.common.collect.FluentIterable;

import java.util.List;

public abstract class EkoCategoryDao<EntityType extends EkoCategoryObject> {

    static <EkoObject extends CategoryEkoObject, CategoryObject extends EkoCategoryObject> void update(List<EkoObject> ekoObjects, EkoCategoryDao<CategoryObject> dao, EkoCategoryObject.EkoCategoryFactory<CategoryObject> factory) {
        for (EkoObject ekoObject : ekoObjects) {
            update(ekoObject, dao, factory);
        }
    }

    static <CategoryObject extends EkoCategoryObject> void update(CategoryEkoObject ekoObject, EkoCategoryDao<CategoryObject> dao, EkoCategoryObject.EkoCategoryFactory<CategoryObject> factory) {
        String[] categoryIds = ekoObject.getCategoryIds().toArray(new String[0]);

        List<CategoryObject> list = FluentIterable.from(categoryIds)
                .transform(category -> factory.create(ekoObject.getId(), category))
                .toList();

        dao.insert(list);
        dao.retainAll(ekoObject.getId(), categoryIds);
    }

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract void insert(List<EntityType> objects);

    abstract void retainAll(String id, String[] categoryIds);
}
