package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import com.amity.socialcloud.sdk.social.data.post.paging.PinKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityPinPagingDao : DynamicQueryStreamPagingDao<PinEntity> {
	
	@RawQuery(observedEntities = [PinEntity::class, AmityPagingId::class])
	override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PinEntity>
	
	fun getPinnedPostPagingSource(
		targetId: String,
		targetType: String,
		placement: String? = null,
		includeMixedStructure: Boolean,
	): PagingSource<Int, PinEntity> {
		return queryPagingData(
			generateQueryStreamSQL(
				tableName = "pin",
				primaryKeyColumnName = "pinId",
				dynamicQueryStreamKeyCreator = PinKeyCreator(
					targetId = targetId,
					targetType = targetType,
					placement = placement,
					includeMixedStructure = includeMixedStructure
				),
				nonce = AmityNonce.PINNED_POST_LIST,
				order = AmityPagingDao.Order.DESC,
				sortColumn = "createdAt",
			)
		)
	}
}