package com.amity.socialcloud.sdk.video.domain.room

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.model.video.room.AmityRoomSortOption
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class RoomQueryPagingDataUseCase {
    fun execute(
        statuses: Array<AmityRoomStatus>?,
        types: Array<AmityRoomType>?,
        isDeleted: Boolean?,
        sortBy: AmityRoomSortOption?
    ): Flowable<PagingData<AmityRoom>> {
        return RoomRepository().getRoomCollectionPagingData(statuses, types, isDeleted, sortBy)
            .map { paging ->
                paging.map(Executors.newSingleThreadExecutor()) { room ->
                    RoomComposerUseCase().execute(room)
                }
            }
    }
}

