package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse
import com.amity.socialcloud.sdk.social.data.event.EventRemoteDataStore
import com.amity.socialcloud.sdk.social.data.event.EventResponseEntityMapper
import com.amity.socialcloud.sdk.social.data.event.EventResponseModelMapper
import com.amity.socialcloud.sdk.social.data.event.EventResponsePersister
import io.reactivex.rxjava3.core.Single

internal class EventGetMyRSVPUseCase {

    fun getMyRSVP(eventId: String): Single<AmityEventResponse> {
        return EventRemoteDataStore()
            .getMyRSVP(eventId)
            .flatMap { dto ->
                EventResponsePersister().persist(dto)
                    .andThen(Single.fromCallable {
                        val responseEntity = dto.eventResponses?.firstOrNull()
                            ?.let { EventResponseEntityMapper().map(listOf(it)).firstOrNull() }
                            ?: throw Exception("RSVP not found")
                        
                        val rsvp = EventResponseModelMapper().map(responseEntity)
                        
                        // Compose the RSVP with linked event and user
                        EventComposerUseCase()
                            .composeRSVP(rsvp, dto.events, dto.users, dto.files)
                            .blockingAwait()
                        
                        rsvp
                    })
            }
    }
}
