package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.amity.socialcloud.sdk.social.data.category.CategoryEntityMapper
import com.amity.socialcloud.sdk.social.data.category.CategoryLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityEntityMapper
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore
import com.amity.socialcloud.sdk.social.data.story.reaction.StoryReactionEntityMapper
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetEntityMapper
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetLocalDataStore
import io.reactivex.rxjava3.core.Completable


internal class StoryQueryPersister : QueryPersister<StoryQueryDto>() {


    override fun persist(dto: StoryQueryDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files ?: emptyList()))
            .andThen(
                UserLocalDataStore().saveUsers(
                    UserEntityMapper().map(
                        dto.users ?: emptyList()
                    )
                )
            )
            .andThen(
                UserFlagLocalDataStore().saveFlags(
                    UserFlagEntityMapper().map(
                        dto.users ?: emptyList()
                    )
                )
            )
            .andThen(
                CategoryLocalDataStore().saveCategories(
                    CategoryEntityMapper().map(
                        dto.communityCategories ?: emptyList()
                    )
                )
            )
            .andThen(
                CommunityMembershipLocalDataStore().saveMemberships(
                    CommunityMembershipEntityMapper().map(dto.communityUsers ?: emptyList())
                )
            )
            .andThen(
                CommunityLocalDataStore().saveCommunities(
                    CommunityEntityMapper().map(
                        dto.communities ?: emptyList()
                    )
                )
            )
            .andThen(
                StoryTargetLocalDataStore().saveStoryTarget(
                    StoryTargetEntityMapper().map(
                        dto.storyTargets ?: emptyList()
                    )
                )
            )
            .andThen(
                ReactionLocalDataStore().saveReactionsAndDeletePrevious(
                    AmityReactionReferenceType.STORY,
                    dto.stories?.map { it.storyId ?: "" } ?: emptyList(),
                    StoryReactionEntityMapper().map(dto.stories ?: emptyList())
                )
            )
            .andThen(
                StoryLocalDataStore().saveStories(
                    StoryEntityMapper().map(
                        dto.stories ?: emptyList()
                    )
                )
            )
    }

}