package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.session.eventbus.CoHostEventBus
import com.amity.socialcloud.sdk.core.session.model.AmityCoHostEvent
import com.amity.socialcloud.sdk.dto.video.RoomListDto
import com.amity.socialcloud.sdk.video.domain.room.GetRoomByIdsUseCase
import io.reactivex.rxjava3.core.Single
import java.util.concurrent.TimeUnit

internal open class RoomParticipantLeft : RoomEventListener() {

    override fun getEventName(): String {
        return "room.participantLeft"
    }

    override fun processEvent(dto: RoomListDto) {
        super.processEvent(dto)
        dto.rooms
            ?.firstOrNull()
            ?.let { room ->
                val roomId = room.roomId
                if (!roomId.isNullOrBlank()) {
                    Single.just(roomId)
                        .delay(200, TimeUnit.MILLISECONDS)
                        .doOnSuccess { roomId ->
                            GetRoomByIdsUseCase().execute(listOf(roomId))
                                .firstOrNull { it.getRoomId() == roomId }
                                ?.let { room ->
                                    CoHostEventBus.publish(
                                            event = AmityCoHostEvent.CoHostLeft(
                                                room = room,
                                            )
                                    )
                                }
                        }
                        .subscribe()
                }
            }
    }

    override fun shouldProcessEvent(dto: RoomListDto): Boolean {
        return true
    }

}