package com.amity.socialcloud.sdk.core.data.presence

import com.ekoapp.ekosdk.internal.api.dto.PresenceSettingDto
import com.ekoapp.ekosdk.internal.api.dto.PresenceUserSettingDto
import com.ekoapp.ekosdk.internal.api.dto.UserPresenceListDto
import com.ekoapp.ekosdk.internal.api.dto.ViewerPresenceListDto
import com.ekoapp.ekosdk.internal.api.socket.request.PresenceUserSettingUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.PUT
import retrofit2.http.Path
import retrofit2.http.Query

interface PresenceApi {

    @GET("api/v1/presence/settings")
    fun getPresenceSetting(): Single<PresenceSettingDto>

    @PUT("api/v1/presence/settings/user")
    fun updatePresenceUserSetting(
        @Body request: PresenceUserSettingUpdateRequest
    ): Single<PresenceUserSettingDto>

    @POST("api/v1/presence/heartbeat")
    fun sendRoomPresenceHeartbeat(): Single<JsonObject>

    @GET("api/v1/presence/users/list")
    fun getUserPresence(
        @Query("userIds[]") userIds: List<String>? = null
    ): Single<UserPresenceListDto>

    @GET("api/v1/presence/network/users")
    fun getOnlineUsers(
        @Query("orderBy") orderBy: String = "desc"
    ): Single<UserPresenceListDto>

    @GET("api/v1/presence/network/users/count")
    fun getOnlineUsersCount(): Single<JsonObject>

    @POST("api/v1/presence/rooms/{roomId}/heartbeat")
    fun sendRoomPresenceHeartbeat(
        @Path("roomId") roomId: String,
    ): Single<JsonObject>

    @GET("api/v1/presence/rooms/{roomId}/users")
    fun getRoomUserPresence(
        @Path("roomId") roomId: String,
    ): Single<ViewerPresenceListDto>

    @GET("api/v1/presence/rooms/{roomId}/users/count")
    fun getRoomOnlineUsersCount(
        @Path("roomId") roomId: String,
    ): Single<JsonObject>

}