package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.data.mention.LegacyMentioneeModelMapper
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.util.PIIUtils


internal class MessageModelMapper : ModelMapper<EkoMessageEntity, AmityMessage>() {

    override fun map(entity: EkoMessageEntity): AmityMessage {
        return entity.run {
            AmityMessage(
                uniqueId = uniqueId,
                messageId = messageId,
                subChannelId = subChannelId,
                channelId = channelId,
                userId = userId,
                parentId = parentId,
                channelSegment = getChannelSegment(),
                childrenNumber = childrenNumber,
                isDeleted = isDeleted,
                flagCount = flagCount,
                tags = getTags(),
                reactions = reactions,
                reactionCount = reactionCount,
                rawData = data,
                type = getDataType(),
                syncState = syncState,
                createdAt = createdAt,
                updatedAt = updatedAt,
                editedAt = editedAt,
                metadata = metadata,
                mentionees = LegacyMentioneeModelMapper().map(entity.mentionees),
                path = path,
                piiList = PIIUtils.parsePIIData(pii)
            )
        }
    }

}