/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.MessageMarkerEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.MessageMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class MessageMarkerDao_Impl
extends MessageMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<MessageMarkerEntity> __insertAdapterOfMessageMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<MessageMarkerEntity> __deleteAdapterOfMessageMarkerEntity;
    private final EntityDeleteOrUpdateAdapter<MessageMarkerEntity> __updateAdapterOfMessageMarkerEntity;

    public MessageMarkerDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfMessageMarkerEntity = new EntityInsertAdapter<MessageMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `message_marker` (`messageId`,`subChannelId`,`readCount`,`deliveredCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessageMarkerEntity entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getSubChannelId());
                }
                statement.bindLong(3, (long)entity.getReadCount());
                statement.bindLong(4, (long)entity.getDeliveredCount());
                String _tmp = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfMessageMarkerEntity = new EntityDeleteOrUpdateAdapter<MessageMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `message_marker` WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessageMarkerEntity entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
            }
        };
        this.__updateAdapterOfMessageMarkerEntity = new EntityDeleteOrUpdateAdapter<MessageMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `message_marker` SET `messageId` = ?,`subChannelId` = ?,`readCount` = ?,`deliveredCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessageMarkerEntity entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getSubChannelId());
                }
                statement.bindLong(3, (long)entity.getReadCount());
                statement.bindLong(4, (long)entity.getDeliveredCount());
                String _tmp = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = MessageMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getMessageId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getMessageId());
                }
            }
        };
    }

    @Override
    public void insertImpl(MessageMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfMessageMarkerEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends MessageMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfMessageMarkerEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(MessageMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfMessageMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends MessageMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfMessageMarkerEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(MessageMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfMessageMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(MessageMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessageMarkerDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends MessageMarkerEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessageMarkerDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(MessageMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessageMarkerDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public MessageMarkerEntity getByIdNow(String messageId) {
        String _sql = "SELECT * from message_marker where messageId = ? LIMIT 1";
        return (MessageMarkerEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_marker where messageId = ? LIMIT 1");){
                MessageMarkerEntity _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfReadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readCount");
                int _columnIndexOfDeliveredCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deliveredCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new MessageMarkerEntity();
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    int _tmpReadCount = (int)_stmt.getLong(_columnIndexOfReadCount);
                    _result.setReadCount(_tmpReadCount);
                    int _tmpDeliveredCount = (int)_stmt.getLong(_columnIndexOfDeliveredCount);
                    _result.setDeliveredCount(_tmpDeliveredCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessageMarkerEntity messageMarkerEntity = _result;
                return messageMarkerEntity;
            }
        });
    }

    @Override
    public Flowable<MessageMarkerEntity> getById(String messageId) {
        String _sql = "SELECT * from message_marker where messageId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message_marker"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_marker where messageId = ? LIMIT 1");){
                MessageMarkerEntity _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfReadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readCount");
                int _columnIndexOfDeliveredCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deliveredCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new MessageMarkerEntity();
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    int _tmpReadCount = (int)_stmt.getLong(_columnIndexOfReadCount);
                    _result.setReadCount(_tmpReadCount);
                    int _tmpDeliveredCount = (int)_stmt.getLong(_columnIndexOfDeliveredCount);
                    _result.setDeliveredCount(_tmpDeliveredCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessageMarkerEntity messageMarkerEntity = _result;
                return messageMarkerEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from message_marker";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_marker");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updatePreviousMarkersReadCount(String subChannelId, int readCout, DateTime createdAt) {
        String _sql = "Update message_marker set readCount = ? where subChannelId = ? and readCount < ? and createdAt <= ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("Update message_marker set readCount = ? where subChannelId = ? and readCount < ? and createdAt <= ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)readCout);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)readCout);
                _argIndex = 4;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _stmt.step();
                Object var8_8 = null;
                return var8_8;
            }
        });
    }

    @Override
    public void updatePreviousMarkersDeliveredCount(String subChannelId, int deliveredCount, DateTime createdAt) {
        String _sql = "Update message_marker set deliveredCount = ? where subChannelId = ? and deliveredCount < ? and createdAt <= ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("Update message_marker set deliveredCount = ? where subChannelId = ? and deliveredCount < ? and createdAt <= ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)deliveredCount);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)deliveredCount);
                _argIndex = 4;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _stmt.step();
                Object var8_8 = null;
                return var8_8;
            }
        });
    }

    @Override
    public void deleteById(String messageId) {
        String _sql = "DELETE from message_marker where messageId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_marker where messageId = ?");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

