/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.domain.room.compose;

import com.amity.socialcloud.sdk.chat.domain.channel.GetChannelUseCase;
import com.amity.socialcloud.sdk.core.data.room.RoomRepository;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.video.domain.room.GetRoomByIdsUseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/video/domain/room/compose/RoomComposerUseCase;", "", "<init>", "()V", "roomRepository", "Lcom/amity/socialcloud/sdk/core/data/room/RoomRepository;", "execute", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "room", "addCreator", "", "addChannel", "addModeration", "addChildRooms", "parentRoom", "addParticipants", "addThumbnail", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nRoomComposerUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomComposerUseCase.kt\ncom/amity/socialcloud/sdk/video/domain/room/compose/RoomComposerUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1563#2:80\n1634#2,3:81\n*S KotlinDebug\n*F\n+ 1 RoomComposerUseCase.kt\ncom/amity/socialcloud/sdk/video/domain/room/compose/RoomComposerUseCase\n*L\n54#1:80\n54#1:81,3\n*E\n"})
public final class RoomComposerUseCase {
    @NotNull
    private final RoomRepository roomRepository = new RoomRepository();

    @NotNull
    public final AmityRoom execute(@NotNull AmityRoom room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        this.addCreator(room);
        this.addChannel(room);
        this.addModeration(room);
        this.addChildRooms(room);
        this.addParticipants(room);
        this.addThumbnail(room);
        return room;
    }

    private final void addCreator(AmityRoom room) {
        block0: {
            String string = room.getCreatorId();
            if (string == null) break block0;
            String id = string;
            boolean bl = false;
            room.setCreator$amity_sdk_release(new UserGetUseCase().execute(id));
        }
    }

    private final void addChannel(AmityRoom room) {
        block0: {
            String string = room.getChannelId();
            if (string == null) break block0;
            String channelId = string;
            boolean bl = false;
            room.setChannel$amity_sdk_release(new GetChannelUseCase().execute(channelId));
        }
    }

    private final void addModeration(AmityRoom room) {
        room.setModeration$amity_sdk_release(this.roomRepository.getRoomModerationByRoom(room.getRoomId()));
    }

    private final void addChildRooms(AmityRoom parentRoom) {
        if (parentRoom.isParent() && !((Collection)parentRoom.getChildRoomIds()).isEmpty()) {
            parentRoom.setChildRooms$amity_sdk_release(new GetRoomByIdsUseCase().execute(parentRoom.getChildRoomIds()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addParticipants(AmityRoom room) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = room.getParticipants();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AmityRoom.Participant participant;
            void participant2;
            AmityRoom.Participant participant3 = (AmityRoom.Participant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String userId = participant2.getUserId();
            boolean bl2 = false;
            AmityUser amityUser = new UserGetUseCase().execute(userId);
            if (amityUser != null) {
                AmityUser user = amityUser;
                boolean bl3 = false;
                String string = participant2.getUserId();
                AmityRoom.ParticipantType participantType = participant2.getType();
                participant = new AmityRoom.Participant(participantType, string, user);
            } else {
                participant = participant2;
            }
            collection.add(participant);
        }
        List participants = (List)destination$iv$iv;
        boolean bl = false;
        room.setParticipants$amity_sdk_release(participants);
    }

    private final void addThumbnail(AmityRoom room) {
        block0: {
            String string = room.getThumbnailFileId$amity_sdk_release();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            room.setThumbnail$amity_sdk_release(new ImageGetUseCase().execute(it));
        }
    }
}

