/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.room;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.room.RoomLocalDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomMediator;
import com.amity.socialcloud.sdk.core.data.room.RoomModerationLocalDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomQueryPersister;
import com.amity.socialcloud.sdk.core.data.room.RoomRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.room.RoomRepository;
import com.amity.socialcloud.sdk.dto.video.EkoRoomBroadcastDataDto;
import com.amity.socialcloud.sdk.dto.video.RoomDto;
import com.amity.socialcloud.sdk.dto.video.RoomListDto;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomModeration;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomSortOption;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus;
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType;
import com.amity.socialcloud.sdk.video.data.room.RoomModelMapper;
import com.amity.socialcloud.sdk.video.data.room.RoomModerationModelMapper;
import com.ekoapp.ekosdk.internal.api.socket.request.CreateRoomRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UpdateRoomRequest;
import com.ekoapp.ekosdk.internal.keycreator.RoomKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002JK\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017JY\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u00112\b\u0010%\u001a\u0004\u0018\u00010\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019\u00a2\u0006\u0002\u0010'JK\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010)\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010.\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017J\u001a\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00190\u001e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0016\u001a\u00020\u0017J#\u00106\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00107J%\u00108\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00192\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00109J\u001b\u0010:\u001a\u00020;2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0000\u00a2\u0006\u0002\b<J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\u0017H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u00022\u0006\u0010>\u001a\u00020\u0017H\u0016J\u0014\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030AH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010>\u001a\u00020\u0017H\u0016\u00a8\u0006C"}, d2={"Lcom/amity/socialcloud/sdk/core/data/room/RoomRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/video/room/RoomEntity;", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "<init>", "()V", "defaultPageSize", "", "getRoomCollectionPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "statuses", "", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;", "types", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;", "isDeleted", "", "sortBy", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomSortOption;", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;[Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomSortOption;)Lio/reactivex/rxjava3/core/Flowable;", "observeRoom", "roomId", "", "getRoomsByIds", "", "roomIds", "fetchRoom", "Lio/reactivex/rxjava3/core/Completable;", "createRoom", "Lio/reactivex/rxjava3/core/Single;", "title", "description", "thumbnailFileId", "metadata", "Lcom/google/gson/JsonObject;", "liveChatEnabled", "parentRoomId", "participants", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;Ljava/lang/String;Ljava/util/List;)Lio/reactivex/rxjava3/core/Single;", "updateRoom", "channelEnabled", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Single;", "deleteRoom", "leaveRoom", "stopRoom", "removeParticipant", "userId", "getRecordedUrls", "getBroadcasterData", "Lcom/amity/socialcloud/sdk/dto/video/EkoRoomBroadcastDataDto;", "getLatestRoom", "getRoomModerationByRoom", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomModeration;", "formatStatuses", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomStatus;)Ljava/util/List;", "formatTypes", "([Lcom/amity/socialcloud/sdk/model/video/room/AmityRoomType;)Ljava/util/List;", "buildQueryToken", "Lcom/ekoapp/ekosdk/internal/token/DynamicQueryStreamQueryToken;", "buildQueryToken$amity_sdk_release", "fetchAndSave", "objectId", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nRoomRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomRepository.kt\ncom/amity/socialcloud/sdk/core/data/room/RoomRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n1563#2:202\n1634#2,3:203\n1#3:206\n11228#4:207\n11563#4,3:208\n11228#4:211\n11563#4,3:212\n*S KotlinDebug\n*F\n+ 1 RoomRepository.kt\ncom/amity/socialcloud/sdk/core/data/room/RoomRepository\n*L\n75#1:202\n75#1:203,3\n168#1:207\n168#1:208,3\n171#1:211\n171#1:212,3\n*E\n"})
public final class RoomRepository
extends AmityObjectRepository<RoomEntity, AmityRoom> {
    private final int defaultPageSize() {
        return 20;
    }

    @NotNull
    public final Flowable<PagingData<AmityRoom>> getRoomCollectionPagingData(@Nullable AmityRoomStatus[] statuses, @Nullable AmityRoomType[] types, @Nullable Boolean isDeleted, @Nullable AmityRoomSortOption sortBy) {
        List<String> statusList = this.formatStatuses(statuses);
        List<String> typeList = this.formatTypes(types);
        AmityRoomSortOption amityRoomSortOption = sortBy;
        String sortKey = amityRoomSortOption != null ? amityRoomSortOption.getApiKey() : null;
        RoomMediator mediator = new RoomMediator(statusList, typeList, isDeleted, sortKey);
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.defaultPageSize(), 0, false, 0, 0, 0, 58, null), null, mediator, () -> RoomRepository.getRoomCollectionPagingData$lambda$0(statusList, typeList, isDeleted, sortKey), (ModelMapper)new RoomModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<AmityRoom> observeRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        Flowable flowable = new RoomLocalDataStore().observeRoom(roomId).map(new Function(roomModelMapper){
            final /* synthetic */ RoomModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final AmityRoom apply(RoomEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AmityRoom> getRoomsByIds(@NotNull List<String> roomIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roomIds, (String)"roomIds");
        Iterable iterable = new RoomLocalDataStore().getRoomsByIds(roomIds);
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            RoomEntity roomEntity = (RoomEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(roomModelMapper.map((RoomEntity)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Completable fetchRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Completable completable = new RoomRemoteDataStore().getRoom(roomId).flatMapCompletable((Function)fetchRoom.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Single<String> createRoom(@NotNull String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean liveChatEnabled, @Nullable String parentRoomId, @NotNull List<String> participants) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        CreateRoomRequest request = new CreateRoomRequest(title, description, thumbnailFileId, metadata, liveChatEnabled, parentRoomId, null, participants, 64, null);
        Single single = new RoomRemoteDataStore().createRoom(request).flatMap((Function)createRoom.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Single<String> updateRoom(@NotNull String roomId, @Nullable String title, @Nullable String description, @Nullable String thumbnailFileId, @Nullable JsonObject metadata, @Nullable Boolean channelEnabled) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        UpdateRoomRequest request = new UpdateRoomRequest(title, description, thumbnailFileId, metadata, channelEnabled, null, 32, null);
        Single single = new RoomRemoteDataStore().updateRoom(roomId, request).flatMap(new Function(roomId){
            final /* synthetic */ String $roomId;
            {
                this.$roomId = $roomId;
            }

            public final SingleSource<? extends String> apply(RoomListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Completable completable = new RoomQueryPersister().persist(dto);
                List<RoomDto> list = dto.getRooms();
                if (list == null || (list = (RoomDto)CollectionsKt.firstOrNull(list)) == null || (list = ((RoomDto)((Object)list)).getRoomId()) == null) {
                    list = this.$roomId;
                }
                return (SingleSource)completable.andThen((SingleSource)Single.just((Object)list));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Completable deleteRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Completable completable = new RoomRemoteDataStore().deleteRoom(roomId).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Completable leaveRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Completable completable = new RoomRemoteDataStore().leaveRoom(roomId).flatMapCompletable((Function)leaveRoom.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Single<String> stopRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Single single = new RoomRemoteDataStore().stopRoom(roomId).flatMap(new Function(roomId){
            final /* synthetic */ String $roomId;
            {
                this.$roomId = $roomId;
            }

            public final SingleSource<? extends String> apply(RoomListDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Completable completable = new RoomQueryPersister().persist(dto);
                List<RoomDto> list = dto.getRooms();
                if (list == null || (list = (RoomDto)CollectionsKt.firstOrNull(list)) == null || (list = ((RoomDto)((Object)list)).getRoomId()) == null) {
                    list = this.$roomId;
                }
                return (SingleSource)completable.andThen((SingleSource)Single.just((Object)list));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Completable removeParticipant(@NotNull String roomId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new RoomRemoteDataStore().removeParticipant(roomId, userId).flatMapCompletable((Function)removeParticipant.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Single<List<String>> getRecordedUrls(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Single single = new RoomRemoteDataStore().getRoomRecordedUrls(roomId).map((Function)getRecordedUrls.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Single<EkoRoomBroadcastDataDto> getBroadcasterData(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return new RoomRemoteDataStore().getBroadcasterData(roomId);
    }

    @NotNull
    public final Flowable<AmityRoom> getLatestRoom(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        RoomModelMapper roomModelMapper = new RoomModelMapper();
        Flowable flowable = new RoomLocalDataStore().getLatestRoom(statuses).map(new Function(roomModelMapper){
            final /* synthetic */ RoomModelMapper $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final AmityRoom apply(RoomEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$tmp0.map(p0);
            }
        }).map((Function)getLatestRoom.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Nullable
    public final AmityRoomModeration getRoomModerationByRoom(@NotNull String roomId) {
        AmityRoomModeration amityRoomModeration;
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        RoomModerationEntity roomModerationEntity = new RoomModerationLocalDataStore().getModerationByRoomId(roomId);
        if (roomModerationEntity != null) {
            RoomModerationEntity it = roomModerationEntity;
            boolean bl = false;
            amityRoomModeration = new RoomModerationModelMapper().map(it);
        } else {
            amityRoomModeration = null;
        }
        return amityRoomModeration;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> formatStatuses(AmityRoomStatus[] statuses) {
        void $this$mapTo$iv$iv;
        AmityRoomStatus[] it;
        Object object;
        block5: {
            AmityRoomStatus[] amityRoomStatusArray;
            block4: {
                object = statuses;
                if (statuses == null) break block4;
                it = amityRoomStatusArray = object;
                boolean bl = false;
                object = !(it.length == 0) ? amityRoomStatusArray : null;
                if (object != null) break block5;
            }
            amityRoomStatusArray = new AmityRoomStatus[]{AmityRoomStatus.IDLE};
            object = amityRoomStatusArray;
        }
        AmityRoomStatus[] $this$map$iv = object;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getApiKey());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<String> formatTypes(AmityRoomType[] types) {
        void $this$mapTo$iv$iv;
        AmityRoomType[] amityRoomTypeArray;
        AmityRoomType[] amityRoomTypeArray2 = types;
        if (types == null) return null;
        AmityRoomType[] it = amityRoomTypeArray = amityRoomTypeArray2;
        boolean $i$a$-takeIf-RoomRepository$formatTypes$22 = false;
        if (it.length == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        AmityRoomType[] amityRoomTypeArray2 = amityRoomTypeArray;
        amityRoomTypeArray2 = amityRoomTypeArray2;
        if (amityRoomTypeArray3 == null) return null;
        AmityRoomType[] $this$map$iv = amityRoomTypeArray2;
        boolean $i$f$map = false;
        AmityRoomType[] $i$a$-takeIf-RoomRepository$formatTypes$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it2.getApiKey());
        }
        List list = (List)destination$iv$iv;
        return list;
    }

    @NotNull
    public final DynamicQueryStreamQueryToken buildQueryToken$amity_sdk_release(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return new DynamicQueryStreamQueryToken(new RoomKeyCreator(statuses, null, null, null), null, null, (List<String>)CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new RoomRemoteDataStore().getRoom(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE).onErrorResumeNext(new Function(objectId){
            final /* synthetic */ String $objectId;
            {
                this.$objectId = $objectId;
            }

            public final CompletableSource apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND ? (CompletableSource)new RoomLocalDataStore().hardDelete(this.$objectId).andThen((CompletableSource)Completable.error((Throwable)it)) : (CompletableSource)Completable.error((Throwable)it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorResumeNext(...)");
        return completable;
    }

    @Override
    @Nullable
    public RoomEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new RoomLocalDataStore().getRoom(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<RoomEntity, AmityRoom> mapper() {
        return new RoomModelMapper();
    }

    @Override
    @NotNull
    public Flowable<RoomEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new RoomLocalDataStore().observeRoom(objectId);
    }

    private static final PagingSource getRoomCollectionPagingData$lambda$0(List $statusList, List $typeList, Boolean $isDeleted, String $sortKey) {
        return new RoomLocalDataStore().getRoomsPagingSource($statusList, $typeList, $isDeleted, $sortKey);
    }
}

