/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.TombstoneDao;
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class TombstoneDao_Impl
extends TombstoneDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<TombstoneEntity> __insertAdapterOfTombstoneEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<TombstoneEntity> __deleteAdapterOfTombstoneEntity;
    private final EntityDeleteOrUpdateAdapter<TombstoneEntity> __updateAdapterOfTombstoneEntity;

    public TombstoneDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfTombstoneEntity = new EntityInsertAdapter<TombstoneEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `tombstone` (`objectId`,`errorCode`,`modelType`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull TombstoneEntity entity) {
                if (entity.getObjectId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getObjectId());
                }
                statement.bindLong(2, (long)entity.getErrorCode());
                if (entity.getModelType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getModelType());
                }
                String _tmp = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfTombstoneEntity = new EntityDeleteOrUpdateAdapter<TombstoneEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `tombstone` WHERE `objectId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull TombstoneEntity entity) {
                if (entity.getObjectId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getObjectId());
                }
            }
        };
        this.__updateAdapterOfTombstoneEntity = new EntityDeleteOrUpdateAdapter<TombstoneEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `tombstone` SET `objectId` = ?,`errorCode` = ?,`modelType` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `objectId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull TombstoneEntity entity) {
                if (entity.getObjectId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getObjectId());
                }
                statement.bindLong(2, (long)entity.getErrorCode());
                if (entity.getModelType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getModelType());
                }
                String _tmp = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = TombstoneDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                if (entity.getObjectId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getObjectId());
                }
            }
        };
    }

    @Override
    public void insertImpl(TombstoneEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfTombstoneEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends TombstoneEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfTombstoneEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(TombstoneEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfTombstoneEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends TombstoneEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfTombstoneEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(TombstoneEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfTombstoneEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(TombstoneEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            TombstoneDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends TombstoneEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            TombstoneDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(TombstoneEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            TombstoneDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public TombstoneEntity getTombstone(String objectId, String tombstoneModelType) {
        String _sql = "select * from tombstone where objectId = ? and modelType = ? LIMIT 1";
        return (TombstoneEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from tombstone where objectId = ? and modelType = ? LIMIT 1");){
                TombstoneEntity _result;
                int _argIndex = 1;
                if (objectId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, objectId);
                }
                _argIndex = 2;
                if (tombstoneModelType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, tombstoneModelType);
                }
                int _columnIndexOfObjectId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"objectId");
                int _columnIndexOfErrorCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"errorCode");
                int _columnIndexOfModelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"modelType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new TombstoneEntity();
                    String _tmpObjectId = _stmt.isNull(_columnIndexOfObjectId) ? null : _stmt.getText(_columnIndexOfObjectId);
                    _result.setObjectId(_tmpObjectId);
                    int _tmpErrorCode = (int)_stmt.getLong(_columnIndexOfErrorCode);
                    _result.setErrorCode(_tmpErrorCode);
                    String _tmpModelType = _stmt.isNull(_columnIndexOfModelType) ? null : _stmt.getText(_columnIndexOfModelType);
                    _result.setModelType(_tmpModelType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                TombstoneEntity tombstoneEntity = _result;
                return tombstoneEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from tombstone";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from tombstone");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

