/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H'J\b\u0010\b\u001a\u00020\u0006H'J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH'J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH'J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H'J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\fH'J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J]\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\fH'\u00a2\u0006\u0002\u0010$JO\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\fH'\u00a2\u0006\u0002\u0010'JU\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010)\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\"H'J\u000e\u0010,\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010-\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH'J\u0016\u0010.\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\fH'J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u001a2\u0006\u0010\u000b\u001a\u00020\fH'J\u001a\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u001a2\u0006\u0010\u000b\u001a\u00020\fJ \u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J\"\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H'J\u001e\u00106\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H'\u00a8\u00068"}, d2={"Lcom/ekoapp/ekosdk/internal/data/dao/PostDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/ekoapp/ekosdk/internal/PostEntity;", "<init>", "()V", "delete", "", "ekoPost", "deleteAll", "deleteById", "Lio/reactivex/rxjava3/core/Completable;", "postId", "", "incrementCommentCount", "decrementCommentCount", "updatePost", "notifyPostByTarget", "targetType", "targetId", "getByIdsNowImpl", "", "postIds", "getByIdsNow", "getByIdNowImpl", "getByIdNow", "getLatestChildrenPostImpl", "Lio/reactivex/rxjava3/core/Flowable;", "postTypes", "hash", "", "nonce", "now", "Lorg/joda/time/DateTime;", "includeDeleted", "", "feedType", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;IILorg/joda/time/DateTime;Ljava/lang/Boolean;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestParentPostImpl", "isDeleted", "(Ljava/lang/String;Ljava/lang/String;IILorg/joda/time/DateTime;Ljava/lang/Boolean;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestPost", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;IILcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;)Lio/reactivex/rxjava3/core/Flowable;", "updateDeletedImpl", "softDeleteById", "updateFeedTypeImpl", "updateFeedType", "getPostImpl", "getPost", "observePostImpl", "observePost", "getByPostIds", "ids", "getByPostIdsImpl", "invalidateChildPosts", "childPostIds", "amity-sdk_release"})
@Dao
public abstract class PostDao
extends EkoObjectDao<PostEntity> {
    @Override
    @Delete
    public abstract void delete(@NotNull PostEntity var1);

    @Override
    @Query(value="DELETE from post")
    public abstract void deleteAll();

    @Query(value="DELETE from post where parentPostId = :postId or postId = :postId")
    @NotNull
    public abstract Completable deleteById(@NotNull String var1);

    @Query(value="UPDATE post set commentCount = commentCount + 1 where postId = :postId")
    public abstract void incrementCommentCount(@NotNull String var1);

    @Query(value="UPDATE post set commentCount = MAX(commentCount - 1, 0)  where postId = :postId")
    public abstract void decrementCommentCount(@NotNull String var1);

    @Query(value="UPDATE post set postId = postId where postId = :postId")
    public abstract void updatePost(@NotNull String var1);

    @Query(value="UPDATE post set postId = postId where targetType = :targetType and targetId = :targetId")
    public abstract void notifyPostByTarget(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT * from post where post.postId IN (:postIds)")
    @NotNull
    public abstract List<PostEntity> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    @NotNull
    public List<PostEntity> getByIdsNow(@NotNull List<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        return this.getByIdsNowImpl(postIds);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    @Nullable
    public abstract PostEntity getByIdNowImpl(@NotNull String var1);

    @Override
    @Nullable
    public PostEntity getByIdNow(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.getByIdNowImpl(postId);
    }

    @Query(value="SELECT * from post, amity_paging_id where post.targetType = :targetType and post.targetId = :targetId  and post.isDeleted = (case when :includeDeleted is null then post.isDeleted else :includeDeleted end) and post.feedType = (case when :feedType is null then post.feedType else :feedType end) and post.postDataType in (:postTypes)  and post.updatedAt > :now and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by post.updatedAt  desc limit 1")
    @NotNull
    public abstract Flowable<PostEntity> getLatestChildrenPostImpl(@NotNull String var1, @NotNull String var2, @NotNull List<String> var3, int var4, int var5, @NotNull DateTime var6, @Nullable Boolean var7, @Nullable String var8);

    @Query(value="SELECT * from post where post.targetType = :targetType and post.targetId = :targetId  and post.parentPostId is null and post.isDeleted = (case when :isDeleted is null then post.isDeleted else :isDeleted end) and post.feedType = (case when :feedType is null then post.feedType else :feedType end) and post.updatedAt > :now and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by post.updatedAt  desc limit 1")
    @NotNull
    public abstract Flowable<PostEntity> getLatestParentPostImpl(@NotNull String var1, @NotNull String var2, int var3, int var4, @NotNull DateTime var5, @Nullable Boolean var6, @Nullable String var7);

    @NotNull
    public final Flowable<PostEntity> getLatestPost(@NotNull String targetId, @NotNull String targetType, @Nullable Boolean includeDeleted, @Nullable List<String> postTypes, int hash, int nonce, @Nullable AmityFeedType feedType) {
        Flowable<PostEntity> flowable;
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        AmityFeedType amityFeedType = feedType;
        String feedTypeKey = amityFeedType != null ? amityFeedType.getApiKey() : null;
        Collection collection = postTypes;
        if (collection == null || collection.isEmpty()) {
            DateTime dateTime = DateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
            flowable = this.getLatestParentPostImpl(targetId, targetType, hash, nonce, dateTime, includeDeleted, feedTypeKey);
        } else {
            DateTime dateTime = DateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
            flowable = this.getLatestChildrenPostImpl(targetId, targetType, postTypes, hash, nonce, dateTime, includeDeleted, feedTypeKey);
        }
        return flowable;
    }

    @Query(value="UPDATE post SET isDeleted = :isDeleted WHERE postId = :postId or parentPostId = :postId")
    @NotNull
    public abstract Completable updateDeletedImpl(@NotNull String var1, boolean var2);

    @NotNull
    public final Completable softDeleteById(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.updateDeletedImpl(postId, true);
    }

    @Query(value="UPDATE post SET feedType = :feedType WHERE postId = :postId ")
    public abstract void updateFeedTypeImpl(@NotNull String var1, @NotNull String var2);

    public final void updateFeedType(@NotNull String postId, @NotNull String feedType) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)feedType, (String)"feedType");
        this.updateFeedTypeImpl(postId, feedType);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    @NotNull
    public abstract Flowable<PostEntity> getPostImpl(@NotNull String var1);

    @NotNull
    public final Flowable<PostEntity> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.getPostImpl(postId);
    }

    @Query(value="SELECT * from post where post.postId IN (:postId)")
    @NotNull
    public abstract Flowable<List<PostEntity>> observePostImpl(@NotNull String var1);

    @NotNull
    public final Flowable<List<PostEntity>> observePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.observePostImpl(postId);
    }

    @NotNull
    public final Flowable<List<PostEntity>> getByPostIds(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.getByPostIdsImpl(ids);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds)")
    @NotNull
    public abstract Flowable<List<PostEntity>> getByPostIdsImpl(@NotNull List<String> var1);

    @Query(value="DELETE from post where parentPostId = :postId and postId not in (:childPostIds)")
    @NotNull
    public abstract Completable invalidateChildPosts(@NotNull String var1, @NotNull List<String> var2);
}

