/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.room;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.amity.socialcloud.sdk.video.data.room.RoomDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class RoomDao_Impl
extends RoomDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<RoomEntity> __insertAdapterOfRoomEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EntityDeleteOrUpdateAdapter<RoomEntity> __deleteAdapterOfRoomEntity;
    private final EntityDeleteOrUpdateAdapter<RoomEntity> __updateAdapterOfRoomEntity;

    public RoomDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfRoomEntity = new EntityInsertAdapter<RoomEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `room` (`roomId`,`type`,`targetType`,`targetId`,`referenceType`,`referenceId`,`channelEnabled`,`channelId`,`title`,`description`,`thumbnailFileId`,`status`,`livePlaybackUrl`,`durationSeconds`,`parentRoomId`,`childRoomIds`,`creatorId`,`isDeleted`,`deletedAt`,`deletedById`,`metadata`,`liveAt`,`endedAt`,`recordedAt`,`recordedUrl`,`recordedThumbnailUrl`,`path`,`participants`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull RoomEntity entity) {
                if (entity.getRoomId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRoomId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getReferenceId());
                }
                int _tmp = entity.getChannelEnabled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                if (entity.getChannelId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getChannelId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getDescription());
                }
                if (entity.getThumbnailFileId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getThumbnailFileId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getStatus());
                }
                if (entity.getLivePlaybackUrl() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getLivePlaybackUrl());
                }
                if (entity.getDurationSeconds() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getDurationSeconds().intValue());
                }
                if (entity.getParentRoomId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getParentRoomId());
                }
                String _tmp_1 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getChildRoomIds());
                if (_tmp_1 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getCreatorId());
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                String _tmp_3 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getDeletedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_3);
                }
                if (entity.getDeletedById() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getDeletedById());
                }
                String _tmp_4 = RoomDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_4);
                }
                String _tmp_5 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLiveAt());
                if (_tmp_5 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_5);
                }
                String _tmp_6 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_6);
                }
                String _tmp_7 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRecordedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_7);
                }
                String _tmp_8 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getRecordedUrl());
                if (_tmp_8 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_8);
                }
                String _tmp_9 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getRecordedThumbnailUrl());
                if (_tmp_9 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_9);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, entity.getPath());
                }
                String _tmp_10 = RoomDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getParticipants());
                if (_tmp_10 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_10);
                }
                String _tmp_11 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, _tmp_11);
                }
                String _tmp_12 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_12 == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindText(30, _tmp_12);
                }
                String _tmp_13 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_13 == null) {
                    statement.bindNull(31);
                } else {
                    statement.bindText(31, _tmp_13);
                }
            }
        };
        this.__deleteAdapterOfRoomEntity = new EntityDeleteOrUpdateAdapter<RoomEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `room` WHERE `roomId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull RoomEntity entity) {
                if (entity.getRoomId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRoomId());
                }
            }
        };
        this.__updateAdapterOfRoomEntity = new EntityDeleteOrUpdateAdapter<RoomEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `room` SET `roomId` = ?,`type` = ?,`targetType` = ?,`targetId` = ?,`referenceType` = ?,`referenceId` = ?,`channelEnabled` = ?,`channelId` = ?,`title` = ?,`description` = ?,`thumbnailFileId` = ?,`status` = ?,`livePlaybackUrl` = ?,`durationSeconds` = ?,`parentRoomId` = ?,`childRoomIds` = ?,`creatorId` = ?,`isDeleted` = ?,`deletedAt` = ?,`deletedById` = ?,`metadata` = ?,`liveAt` = ?,`endedAt` = ?,`recordedAt` = ?,`recordedUrl` = ?,`recordedThumbnailUrl` = ?,`path` = ?,`participants` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `roomId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull RoomEntity entity) {
                if (entity.getRoomId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRoomId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getReferenceId());
                }
                int _tmp = entity.getChannelEnabled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                if (entity.getChannelId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getChannelId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getDescription());
                }
                if (entity.getThumbnailFileId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getThumbnailFileId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getStatus());
                }
                if (entity.getLivePlaybackUrl() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getLivePlaybackUrl());
                }
                if (entity.getDurationSeconds() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getDurationSeconds().intValue());
                }
                if (entity.getParentRoomId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getParentRoomId());
                }
                String _tmp_1 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getChildRoomIds());
                if (_tmp_1 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getCreatorId());
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                String _tmp_3 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getDeletedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_3);
                }
                if (entity.getDeletedById() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getDeletedById());
                }
                String _tmp_4 = RoomDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_4);
                }
                String _tmp_5 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLiveAt());
                if (_tmp_5 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_5);
                }
                String _tmp_6 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_6);
                }
                String _tmp_7 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRecordedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_7);
                }
                String _tmp_8 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getRecordedUrl());
                if (_tmp_8 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_8);
                }
                String _tmp_9 = RoomDao_Impl.this.__stringListConverter.stringListToString(entity.getRecordedThumbnailUrl());
                if (_tmp_9 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_9);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, entity.getPath());
                }
                String _tmp_10 = RoomDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getParticipants());
                if (_tmp_10 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_10);
                }
                String _tmp_11 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, _tmp_11);
                }
                String _tmp_12 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_12 == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindText(30, _tmp_12);
                }
                String _tmp_13 = RoomDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_13 == null) {
                    statement.bindNull(31);
                } else {
                    statement.bindText(31, _tmp_13);
                }
                if (entity.getRoomId() == null) {
                    statement.bindNull(32);
                } else {
                    statement.bindText(32, entity.getRoomId());
                }
            }
        };
    }

    @Override
    public void insertImpl(RoomEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfRoomEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends RoomEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfRoomEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(RoomEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfRoomEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends RoomEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfRoomEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(RoomEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfRoomEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(RoomEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            RoomDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends RoomEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            RoomDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(RoomEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            RoomDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateRoom(String roomId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            RoomDao_Impl.super.updateRoom(roomId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<RoomEntity> getByIdImpl(String roomId) {
        String _sql = "SELECT * FROM room WHERE roomId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"room"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM room WHERE roomId = ?");){
                RoomEntity _result;
                int _argIndex = 1;
                if (roomId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, roomId);
                }
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfLivePlaybackUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"livePlaybackUrl");
                int _columnIndexOfDurationSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"durationSeconds");
                int _columnIndexOfParentRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentRoomId");
                int _columnIndexOfChildRoomIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childRoomIds");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfDeletedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedAt");
                int _columnIndexOfDeletedById = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedById");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfLiveAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"liveAt");
                int _columnIndexOfEndedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endedAt");
                int _columnIndexOfRecordedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedAt");
                int _columnIndexOfRecordedUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedUrl");
                int _columnIndexOfRecordedThumbnailUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedThumbnailUrl");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParticipants = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"participants");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new RoomEntity();
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _result.setRoomId(_tmpRoomId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfChannelEnabled);
                    boolean _tmpChannelEnabled = _tmp != 0;
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpLivePlaybackUrl = _stmt.isNull(_columnIndexOfLivePlaybackUrl) ? null : _stmt.getText(_columnIndexOfLivePlaybackUrl);
                    _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                    Integer _tmpDurationSeconds = _stmt.isNull(_columnIndexOfDurationSeconds) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfDurationSeconds));
                    _result.setDurationSeconds(_tmpDurationSeconds);
                    String _tmpParentRoomId = _stmt.isNull(_columnIndexOfParentRoomId) ? null : _stmt.getText(_columnIndexOfParentRoomId);
                    _result.setParentRoomId(_tmpParentRoomId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfChildRoomIds) ? null : _stmt.getText(_columnIndexOfChildRoomIds);
                    List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_1);
                    _result.setChildRoomIds(_tmpChildRoomIds);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfDeletedAt) ? null : _stmt.getText(_columnIndexOfDeletedAt);
                    DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setDeletedAt(_tmpDeletedAt);
                    String _tmpDeletedById = _stmt.isNull(_columnIndexOfDeletedById) ? null : _stmt.getText(_columnIndexOfDeletedById);
                    _result.setDeletedById(_tmpDeletedById);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLiveAt) ? null : _stmt.getText(_columnIndexOfLiveAt);
                    DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLiveAt(_tmpLiveAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEndedAt) ? null : _stmt.getText(_columnIndexOfEndedAt);
                    DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setEndedAt(_tmpEndedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfRecordedAt) ? null : _stmt.getText(_columnIndexOfRecordedAt);
                    DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setRecordedAt(_tmpRecordedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfRecordedUrl) ? null : _stmt.getText(_columnIndexOfRecordedUrl);
                    List<String> _tmpRecordedUrl = this.__stringListConverter.stringToStringList(_tmp_8);
                    _result.setRecordedUrl(_tmpRecordedUrl);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfRecordedThumbnailUrl) ? null : _stmt.getText(_columnIndexOfRecordedThumbnailUrl);
                    List<String> _tmpRecordedThumbnailUrl = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setRecordedThumbnailUrl(_tmpRecordedThumbnailUrl);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfParticipants) ? null : _stmt.getText(_columnIndexOfParticipants);
                    JsonArray _tmpParticipants = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_10);
                    _result.setParticipants(_tmpParticipants);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                RoomEntity roomEntity = _result;
                return roomEntity;
            }
        });
    }

    @Override
    public RoomEntity getByIdNowImpl(String roomId) {
        String _sql = "SELECT * FROM room WHERE roomId = ?";
        return (RoomEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM room WHERE roomId = ?");){
                RoomEntity _result;
                int _argIndex = 1;
                if (roomId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, roomId);
                }
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfLivePlaybackUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"livePlaybackUrl");
                int _columnIndexOfDurationSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"durationSeconds");
                int _columnIndexOfParentRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentRoomId");
                int _columnIndexOfChildRoomIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childRoomIds");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfDeletedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedAt");
                int _columnIndexOfDeletedById = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedById");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfLiveAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"liveAt");
                int _columnIndexOfEndedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endedAt");
                int _columnIndexOfRecordedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedAt");
                int _columnIndexOfRecordedUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedUrl");
                int _columnIndexOfRecordedThumbnailUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedThumbnailUrl");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParticipants = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"participants");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new RoomEntity();
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _result.setRoomId(_tmpRoomId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfChannelEnabled);
                    boolean _tmpChannelEnabled = _tmp != 0;
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpLivePlaybackUrl = _stmt.isNull(_columnIndexOfLivePlaybackUrl) ? null : _stmt.getText(_columnIndexOfLivePlaybackUrl);
                    _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                    Integer _tmpDurationSeconds = _stmt.isNull(_columnIndexOfDurationSeconds) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfDurationSeconds));
                    _result.setDurationSeconds(_tmpDurationSeconds);
                    String _tmpParentRoomId = _stmt.isNull(_columnIndexOfParentRoomId) ? null : _stmt.getText(_columnIndexOfParentRoomId);
                    _result.setParentRoomId(_tmpParentRoomId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfChildRoomIds) ? null : _stmt.getText(_columnIndexOfChildRoomIds);
                    List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_1);
                    _result.setChildRoomIds(_tmpChildRoomIds);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfDeletedAt) ? null : _stmt.getText(_columnIndexOfDeletedAt);
                    DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setDeletedAt(_tmpDeletedAt);
                    String _tmpDeletedById = _stmt.isNull(_columnIndexOfDeletedById) ? null : _stmt.getText(_columnIndexOfDeletedById);
                    _result.setDeletedById(_tmpDeletedById);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLiveAt) ? null : _stmt.getText(_columnIndexOfLiveAt);
                    DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLiveAt(_tmpLiveAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEndedAt) ? null : _stmt.getText(_columnIndexOfEndedAt);
                    DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setEndedAt(_tmpEndedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfRecordedAt) ? null : _stmt.getText(_columnIndexOfRecordedAt);
                    DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setRecordedAt(_tmpRecordedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfRecordedUrl) ? null : _stmt.getText(_columnIndexOfRecordedUrl);
                    List<String> _tmpRecordedUrl = this.__stringListConverter.stringToStringList(_tmp_8);
                    _result.setRecordedUrl(_tmpRecordedUrl);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfRecordedThumbnailUrl) ? null : _stmt.getText(_columnIndexOfRecordedThumbnailUrl);
                    List<String> _tmpRecordedThumbnailUrl = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setRecordedThumbnailUrl(_tmpRecordedThumbnailUrl);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfParticipants) ? null : _stmt.getText(_columnIndexOfParticipants);
                    JsonArray _tmpParticipants = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_10);
                    _result.setParticipants(_tmpParticipants);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                RoomEntity roomEntity = _result;
                return roomEntity;
            }
        });
    }

    @Override
    public List<RoomEntity> getByIdsNowImpl(List<String> roomIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * FROM room WHERE roomId in (");
        int _inputSize = roomIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : roomIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfLivePlaybackUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"livePlaybackUrl");
                int _columnIndexOfDurationSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"durationSeconds");
                int _columnIndexOfParentRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentRoomId");
                int _columnIndexOfChildRoomIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childRoomIds");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfDeletedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedAt");
                int _columnIndexOfDeletedById = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedById");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfLiveAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"liveAt");
                int _columnIndexOfEndedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endedAt");
                int _columnIndexOfRecordedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedAt");
                int _columnIndexOfRecordedUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedUrl");
                int _columnIndexOfRecordedThumbnailUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedThumbnailUrl");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParticipants = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"participants");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<RoomEntity> _result = new ArrayList<RoomEntity>();
                while (_stmt.step()) {
                    RoomEntity _item_1 = new RoomEntity();
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _item_1.setRoomId(_tmpRoomId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_1.setType(_tmpType);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item_1.setReferenceType(_tmpReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item_1.setReferenceId(_tmpReferenceId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfChannelEnabled);
                    boolean _tmpChannelEnabled = _tmp != 0;
                    _item_1.setChannelEnabled(_tmpChannelEnabled);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _item_1.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item_1.setDescription(_tmpDescription);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _item_1.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item_1.setStatus(_tmpStatus);
                    String _tmpLivePlaybackUrl = _stmt.isNull(_columnIndexOfLivePlaybackUrl) ? null : _stmt.getText(_columnIndexOfLivePlaybackUrl);
                    _item_1.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                    Integer _tmpDurationSeconds = _stmt.isNull(_columnIndexOfDurationSeconds) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfDurationSeconds));
                    _item_1.setDurationSeconds(_tmpDurationSeconds);
                    String _tmpParentRoomId = _stmt.isNull(_columnIndexOfParentRoomId) ? null : _stmt.getText(_columnIndexOfParentRoomId);
                    _item_1.setParentRoomId(_tmpParentRoomId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfChildRoomIds) ? null : _stmt.getText(_columnIndexOfChildRoomIds);
                    List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_1);
                    _item_1.setChildRoomIds(_tmpChildRoomIds);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _item_1.setCreatorId(_tmpCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfDeletedAt) ? null : _stmt.getText(_columnIndexOfDeletedAt);
                    DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setDeletedAt(_tmpDeletedAt);
                    String _tmpDeletedById = _stmt.isNull(_columnIndexOfDeletedById) ? null : _stmt.getText(_columnIndexOfDeletedById);
                    _item_1.setDeletedById(_tmpDeletedById);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setMetadata(_tmpMetadata);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLiveAt) ? null : _stmt.getText(_columnIndexOfLiveAt);
                    DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setLiveAt(_tmpLiveAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEndedAt) ? null : _stmt.getText(_columnIndexOfEndedAt);
                    DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item_1.setEndedAt(_tmpEndedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfRecordedAt) ? null : _stmt.getText(_columnIndexOfRecordedAt);
                    DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setRecordedAt(_tmpRecordedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfRecordedUrl) ? null : _stmt.getText(_columnIndexOfRecordedUrl);
                    List<String> _tmpRecordedUrl = this.__stringListConverter.stringToStringList(_tmp_8);
                    _item_1.setRecordedUrl(_tmpRecordedUrl);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfRecordedThumbnailUrl) ? null : _stmt.getText(_columnIndexOfRecordedThumbnailUrl);
                    List<String> _tmpRecordedThumbnailUrl = this.__stringListConverter.stringToStringList(_tmp_9);
                    _item_1.setRecordedThumbnailUrl(_tmpRecordedThumbnailUrl);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfParticipants) ? null : _stmt.getText(_columnIndexOfParticipants);
                    JsonArray _tmpParticipants = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_10);
                    _item_1.setParticipants(_tmpParticipants);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<RoomEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<RoomEntity> getLatestRoomImpl(List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * FROM room WHERE status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND room.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ORDER BY room.updatedAt DESC LIMIT 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"room"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                RoomEntity _result;
                int _argIndex = 1;
                for (String _item : statuses) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 1 + _inputSize;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roomId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfLivePlaybackUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"livePlaybackUrl");
                int _columnIndexOfDurationSeconds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"durationSeconds");
                int _columnIndexOfParentRoomId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentRoomId");
                int _columnIndexOfChildRoomIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childRoomIds");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfDeletedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedAt");
                int _columnIndexOfDeletedById = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deletedById");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfLiveAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"liveAt");
                int _columnIndexOfEndedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endedAt");
                int _columnIndexOfRecordedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedAt");
                int _columnIndexOfRecordedUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedUrl");
                int _columnIndexOfRecordedThumbnailUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordedThumbnailUrl");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParticipants = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"participants");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new RoomEntity();
                    String _tmpRoomId = _stmt.isNull(_columnIndexOfRoomId) ? null : _stmt.getText(_columnIndexOfRoomId);
                    _result.setRoomId(_tmpRoomId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfChannelEnabled);
                    boolean _tmpChannelEnabled = _tmp_1 != 0;
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpLivePlaybackUrl = _stmt.isNull(_columnIndexOfLivePlaybackUrl) ? null : _stmt.getText(_columnIndexOfLivePlaybackUrl);
                    _result.setLivePlaybackUrl(_tmpLivePlaybackUrl);
                    Integer _tmpDurationSeconds = _stmt.isNull(_columnIndexOfDurationSeconds) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfDurationSeconds));
                    _result.setDurationSeconds(_tmpDurationSeconds);
                    String _tmpParentRoomId = _stmt.isNull(_columnIndexOfParentRoomId) ? null : _stmt.getText(_columnIndexOfParentRoomId);
                    _result.setParentRoomId(_tmpParentRoomId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfChildRoomIds) ? null : _stmt.getText(_columnIndexOfChildRoomIds);
                    List<String> _tmpChildRoomIds = this.__stringListConverter.stringToStringList(_tmp_2);
                    _result.setChildRoomIds(_tmpChildRoomIds);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfDeletedAt) ? null : _stmt.getText(_columnIndexOfDeletedAt);
                    DateTime _tmpDeletedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setDeletedAt(_tmpDeletedAt);
                    String _tmpDeletedById = _stmt.isNull(_columnIndexOfDeletedById) ? null : _stmt.getText(_columnIndexOfDeletedById);
                    _result.setDeletedById(_tmpDeletedById);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLiveAt) ? null : _stmt.getText(_columnIndexOfLiveAt);
                    DateTime _tmpLiveAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setLiveAt(_tmpLiveAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEndedAt) ? null : _stmt.getText(_columnIndexOfEndedAt);
                    DateTime _tmpEndedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setEndedAt(_tmpEndedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfRecordedAt) ? null : _stmt.getText(_columnIndexOfRecordedAt);
                    DateTime _tmpRecordedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setRecordedAt(_tmpRecordedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfRecordedUrl) ? null : _stmt.getText(_columnIndexOfRecordedUrl);
                    List<String> _tmpRecordedUrl = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setRecordedUrl(_tmpRecordedUrl);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfRecordedThumbnailUrl) ? null : _stmt.getText(_columnIndexOfRecordedThumbnailUrl);
                    List<String> _tmpRecordedThumbnailUrl = this.__stringListConverter.stringToStringList(_tmp_10);
                    _result.setRecordedThumbnailUrl(_tmpRecordedThumbnailUrl);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfParticipants) ? null : _stmt.getText(_columnIndexOfParticipants);
                    JsonArray _tmpParticipants = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setParticipants(_tmpParticipants);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                RoomEntity roomEntity = _result;
                return roomEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE FROM room";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM room");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateRoomImpl(String roomId) {
        String _sql = "UPDATE room set roomId = ? where roomId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE room set roomId = ? where roomId = ?");){
                int _argIndex = 1;
                if (roomId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, roomId);
                }
                _argIndex = 2;
                if (roomId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, roomId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public Completable deleteById(String roomId) {
        String _sql = "DELETE from room where roomId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from room where roomId = ?");){
                int _argIndex = 1;
                if (roomId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, roomId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

