/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.event;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.model.social.event.AmityEvent;
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType;
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityModelMapper;
import com.amity.socialcloud.sdk.social.data.event.EventEntityMapper;
import com.amity.socialcloud.sdk.social.data.event.EventModelMapper;
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.dto.EventDto;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/event/EventComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "<init>", "()V", "execute", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEvent;", "event", "addCreator", "", "addCoverImage", "addTargetCommunity", "composeRSVP", "Lio/reactivex/rxjava3/core/Completable;", "rsvp", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventResponse;", "events", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EventDto;", "users", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoUserDto;", "files", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoFileDto;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventComposerUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/event/EventComposerUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class EventComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityEvent execute(@NotNull AmityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.addCreator(event);
        this.addCoverImage(event);
        this.addTargetCommunity(event);
        return event;
    }

    private final void addCreator(AmityEvent event) {
        event.setCreator$amity_sdk_release(new UserGetUseCase().execute(event.getUserId()));
    }

    private final void addCoverImage(AmityEvent event) {
        block0: {
            String string = event.getCoverImageFileId();
            if (string == null) break block0;
            String fileId = string;
            boolean bl = false;
            event.setCoverImage$amity_sdk_release(new ImageGetUseCase().execute(fileId));
        }
    }

    private final void addTargetCommunity(AmityEvent event) {
        block1: {
            CommunityEntity communityEntity;
            if (event.getOriginType() != AmityEventOriginType.COMMUNITY) break block1;
            CommunityEntity communityEntity2 = communityEntity = new CommunityLocalDataStore().getCommunityById(event.getOriginId());
            if (communityEntity2 != null) {
                CommunityEntity it = communityEntity2;
                boolean bl = false;
                event.setTargetCommunity$amity_sdk_release(new CommunityModelMapper().map(it));
            }
        }
    }

    @NotNull
    public final Completable composeRSVP(@NotNull AmityEventResponse rsvp, @Nullable List<EventDto> events, @Nullable List<? extends EkoUserDto> users, @Nullable List<EkoFileDto> files) {
        Intrinsics.checkNotNullParameter((Object)rsvp, (String)"rsvp");
        Completable completable = Completable.fromAction(() -> EventComposerUseCase.composeRSVP$lambda$5(events, rsvp, this));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    private static final void composeRSVP$lambda$5(List $events, AmityEventResponse $rsvp, EventComposerUseCase this$0) {
        Object object = $events;
        if (object != null) {
            Object v1;
            Object it;
            block4: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    it = (EventDto)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((EventDto)it).getEventId(), (Object)$rsvp.getEventId())) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((object = (EventDto)v1) != null) {
                EventEntity eventEntity;
                Object eventDto = object;
                boolean bl = false;
                EventEntity eventEntity2 = eventEntity = (EventEntity)CollectionsKt.firstOrNull(new EventEntityMapper().map(CollectionsKt.listOf((Object)eventDto)));
                if (eventEntity2 != null) {
                    it = eventEntity2;
                    boolean bl2 = false;
                    AmityEvent event = new EventModelMapper().map((EventEntity)it);
                    this$0.execute(event);
                    $rsvp.setEvent$amity_sdk_release(event);
                }
            }
        }
        $rsvp.setUser$amity_sdk_release(new UserGetUseCase().execute($rsvp.getUserId()));
    }
}

