/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.comment;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.domain.comment.LatestRepliesGetUseCase;
import com.amity.socialcloud.sdk.social.domain.comment.flag.IsCommentFlaggedByMeUseCase;
import com.amity.socialcloud.sdk.social.domain.community.member.CommunityMemberGetUseCase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/comment/CommentComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "<init>", "()V", "execute", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "comment", "addMyReactions", "", "addMyFlag", "addCommentUser", "addMentioneeUser", "addLatestReplies", "addData", "getAttachment", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment$Attachment;", "attachment", "Lcom/google/gson/JsonObject;", "addTarget", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommentComposerUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/comment/CommentComposerUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1563#2:96\n1634#2,3:97\n1617#2,9:100\n1869#2:109\n1870#2:111\n1626#2:112\n1617#2,9:113\n1869#2:122\n1870#2:124\n1626#2:125\n1#3:110\n1#3:123\n*S KotlinDebug\n*F\n+ 1 CommentComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/comment/CommentComposerUseCase\n*L\n44#1:96\n44#1:97,3\n61#1:100,9\n61#1:109\n61#1:111\n61#1:112\n63#1:113,9\n63#1:122\n63#1:124\n63#1:125\n61#1:110\n63#1:123\n*E\n"})
public final class CommentComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityComment execute(@NotNull AmityComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.addLatestReplies(comment);
        this.addMyReactions(comment);
        this.addMyFlag(comment);
        this.addCommentUser(comment);
        this.addMentioneeUser(comment);
        this.addData(comment);
        this.addTarget(comment);
        return comment;
    }

    private final void addMyReactions(AmityComment comment) {
        comment.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.COMMENT, comment.getCommentId()));
    }

    private final void addMyFlag(AmityComment comment) {
        comment.setFlaggedByMe$amity_sdk_release(new IsCommentFlaggedByMeUseCase().execute(comment.getCommentId()));
    }

    private final void addCommentUser(AmityComment comment) {
        comment.setUser$amity_sdk_release(new UserGetUseCase().execute(comment.getCreatorId()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMentioneeUser(AmityComment comment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = comment.getMentionees();
        AmityComment amityComment = comment;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityMentionee amityMentionee = (AmityMentionee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof AmityMentionee.USER) {
                ((AmityMentionee.USER)it).setUser$amity_sdk_release(new UserGetUseCase().execute(((AmityMentionee.USER)it).getUserId()));
            }
            collection.add(it);
        }
        amityComment.setMentionees$amity_sdk_release((List)destination$iv$iv);
    }

    private final void addLatestReplies(AmityComment comment) {
        comment.setLatestReplies$amity_sdk_release(new LatestRepliesGetUseCase().execute(comment.getReferenceType$amity_sdk_release(), comment.getReferenceId$amity_sdk_release(), comment.getCommentId()));
    }

    private final void addData(AmityComment comment) {
        Object it$iv$iv;
        boolean bl;
        JsonElement it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        JsonArray jsonArray = comment.getRawAttachments$amity_sdk_release().getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
        Iterable iterable = (Iterable)jsonArray;
        AmityComment amityComment = comment;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (JsonElement)element$iv$iv;
            boolean bl3 = false;
            if (it.getAsJsonObject() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (JsonObject)element$iv$iv;
            boolean bl4 = false;
            if (this.getAttachment((JsonObject)it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        amityComment.setAttachments$amity_sdk_release((List)destination$iv$iv);
    }

    private final AmityComment.Attachment getAttachment(JsonObject attachment) {
        if (Intrinsics.areEqual((Object)attachment.get("type").getAsString(), (Object)AmityComment.DataType.IMAGE.getApiKey())) {
            AmityComment.Attachment.IMAGE iMAGE;
            String fileId;
            JsonElement jsonElement = attachment.get("fileId");
            String string = fileId = jsonElement != null ? jsonElement.getAsString() : null;
            if (string != null) {
                String it = string;
                boolean bl = false;
                iMAGE = new AmityComment.Attachment.IMAGE(fileId, new ImageGetUseCase().execute(it));
            } else {
                iMAGE = null;
            }
            return iMAGE;
        }
        return null;
    }

    private final void addTarget(AmityComment comment) {
        AmityComment.Target target = comment.getTarget$amity_sdk_release();
        if (target instanceof AmityComment.Target.COMMUNITY) {
            ((AmityComment.Target.COMMUNITY)target).setCreatorCommunityMember$amity_sdk_release(new CommunityMemberGetUseCase().execute(((AmityComment.Target.COMMUNITY)target).getTargetCommunityId$amity_sdk_release(), ((AmityComment.Target.COMMUNITY)target).getCreatorCommunityMemberId$amity_sdk_release()));
        }
    }
}

