/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption;
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventSortOption;
import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType;
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus;
import com.amity.socialcloud.sdk.model.social.event.AmityEventType;
import com.amity.socialcloud.sdk.social.data.event.EventDao;
import com.amity.socialcloud.sdk.social.data.event.EventLocalDataStore;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJc\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J^\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006)"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore;", "", "<init>", "()V", "hasInLocal", "", "eventId", "", "saveEvents", "Lio/reactivex/rxjava3/core/Completable;", "events", "", "Lcom/amity/socialcloud/sdk/entity/social/event/EventEntity;", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "getEvent", "getEvents", "eventIds", "getEventPagingSource", "Landroidx/paging/PagingSource;", "", "originType", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;", "originId", "userId", "status", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;", "type", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;", "onlyAttendee", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventSortOption;", "orderBy", "Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventOrderOption;", "(Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventSortOption;Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventOrderOption;)Landroidx/paging/PagingSource;", "getLatestEvent", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "notifyChanges", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1193#2,2:125\n1267#2,4:127\n1056#2:131\n*S KotlinDebug\n*F\n+ 1 EventLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventLocalDataStore\n*L\n62#1:125,2\n62#1:127,4\n63#1:131\n*E\n"})
public final class EventLocalDataStore {
    public final boolean hasInLocal(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return UserDatabase.get().eventDao().getByIdNow(eventId) != null;
    }

    @NotNull
    public final Completable saveEvents(@NotNull List<? extends EventEntity> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Completable completable = Completable.fromAction(() -> EventLocalDataStore.saveEvents$lambda$0(events));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Flowable<EventEntity> observe(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Flowable flowable = UserDatabase.get().eventDao().observeEvent(eventId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Nullable
    public final EventEntity getEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Ref.ObjectRef event = new Ref.ObjectRef();
        Completable.fromCallable(() -> EventLocalDataStore.getEvent$lambda$1(eventId, event)).subscribeOn(Schedulers.io()).blockingAwait();
        return (EventEntity)event.element;
    }

    @NotNull
    public final List<EventEntity> getEvents(@NotNull List<String> eventIds) {
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        Ref.ObjectRef events = new Ref.ObjectRef();
        events.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> EventLocalDataStore.getEvents$lambda$5(eventIds, events)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)events.element;
    }

    @NotNull
    public final PagingSource<Integer, EventEntity> getEventPagingSource(@Nullable AmityEventOriginType originType, @Nullable String originId, @Nullable String userId, @Nullable AmityEventStatus status, @Nullable AmityEventType type2, @Nullable Boolean onlyAttendee, @NotNull AmityEventSortOption sortBy, @NotNull AmityEventOrderOption orderBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)((Object)orderBy), (String)"orderBy");
        return UserDatabase.get().eventPagingDao().getEventPagingSource(originType, originId, userId, status, type2, onlyAttendee, sortBy, orderBy);
    }

    @NotNull
    public final Flowable<EventEntity> getLatestEvent(@Nullable AmityEventOriginType originType, @Nullable String originId, @Nullable String userId, @Nullable AmityEventStatus status, @Nullable AmityEventType type2, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce, @NotNull AmityEventSortOption sortBy, @NotNull AmityEventOrderOption orderBy) {
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)((Object)orderBy), (String)"orderBy");
        EventDao eventDao = UserDatabase.get().eventDao();
        AmityEventOriginType amityEventOriginType = originType;
        String string = amityEventOriginType != null ? amityEventOriginType.getApiKey() : null;
        AmityEventStatus amityEventStatus = status;
        String string2 = amityEventStatus != null ? amityEventStatus.getApiKey() : null;
        AmityEventType amityEventType = type2;
        String string3 = amityEventType != null ? amityEventType.getApiKey() : null;
        int n = ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        return eventDao.getLatestEvent(string, originId, userId, string2, string3, n, nonce, dateTime, sortBy.getValue(), orderBy.getValue());
    }

    public final void notifyChanges(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        UserDatabase.get().eventDao().notifyChanges(eventId);
    }

    private static final void saveEvents$lambda$0(List $events) {
        UserDatabase.get().eventDao().save($events);
    }

    private static final Unit getEvent$lambda$1(String $eventId, Ref.ObjectRef $event) {
        EventEntity entity = UserDatabase.get().eventDao().getByIdNow($eventId);
        if (entity != null) {
            $event.element = entity;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getEvents$lambda$5(List $eventIds, Ref.ObjectRef $events) {
        EventDao eventDao = UserDatabase.get().eventDao();
        List<EventEntity> entities = eventDao.getByIdsNow($eventIds);
        if (!((Collection)entities).isEmpty()) {
            void results;
            void $this$associateTo$iv$iv;
            List<EventEntity> list = entities;
            Ref.ObjectRef objectRef = $events;
            boolean bl = false;
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)$eventIds);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map orderById = destination$iv$iv;
            Iterable $this$sortedBy$iv = (Iterable)results;
            boolean $i$f$sortedBy = false;
            List sortedEvents = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
                final /* synthetic */ Map $orderById$inlined;
                {
                    this.$orderById$inlined = map;
                }

                public final int compare(T a, T b) {
                    EventEntity it = (EventEntity)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)this.$orderById$inlined.get(it.getEventId());
                    it = (EventEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getEventId())));
                }
            });
            objectRef.element = sortedEvents;
        }
        return Unit.INSTANCE;
    }
}

