package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.data.settings.network.chat.MessagePreviewSettingModelMapper
import com.amity.socialcloud.sdk.model.chat.settings.AmityChatSettings
import com.ekoapp.ekosdk.internal.ChatSettingsEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Flowable

internal class GetChatSettingsUseCase {
    fun execute(): Flowable<AmityChatSettings> {
        val channelDao = UserDatabase.get().chatSettingsDao()
        return channelDao.getChatSettings(ChatSettingsEntity.CHAT_SETTINGS_ID).map {
            AmityChatSettings(
                isEnabled = it.enabled,
                isMentionChannelEnabled = it.isAllowMentionedChannelEnabled,
                messagePreviewSetting = MessagePreviewSettingModelMapper().map(it),
            )
        }
    }
}