package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.ChannelReadReceiptEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class ChannelReadReceiptDao : EkoObjectDao<ChannelReadReceiptEntity>() {
	@Query("SELECT * from channel_read_receipt where channelId = :channelId LIMIT 1")
	abstract fun getById(channelId: String): Flowable<ChannelReadReceiptEntity>

	@Query("SELECT * from channel_read_receipt where channelId = :id LIMIT 1")
	abstract override fun getByIdNow(id: String): ChannelReadReceiptEntity?

	@Query("DELETE from channel_read_receipt")
	abstract override fun deleteAll()

	@Query("DELETE from channel_read_receipt where channelId = :channelId")
	abstract fun deleteByChannelId(channelId: String)

	@Query("UPDATE channel_read_receipt set latestSegment = :segment where channelId = :channelId and latestSegment < :segment")
	abstract fun updateLatestSegment(channelId: String, segment: Int)

	@Query("UPDATE channel_read_receipt set latestSyncSegment = :segment where channelId = :channelId and latestSyncSegment < :segment")
	abstract fun updateLatestSyncSegment(channelId: String, segment: Int)

	@Query("SELECT * from channel_read_receipt where latestSyncSegment < latestSegment")
	abstract fun getUnsyncReadReceipts(): List<ChannelReadReceiptEntity>
}