package com.amity.socialcloud.sdk.social.domain.comment

import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository

class LatestRepliesGetUseCase {

    fun execute(referenceType: String, referenceId: String, parentId: String): List<AmityComment> {
        return CommentRepository().getLatestReplies(
            referenceType = referenceType,
            referenceId = referenceId,
            parentId = parentId
        ).map {
            CommentComposerUseCase().execute(it)
        }
    }

}