package com.amity.socialcloud.sdk.social.data.post.live

import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

internal class LiveRoomPostKeyCreator(
    private val targetType: String,
    private val targetIds: List<String>
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        val params = mutableMapOf<String, Any>("targetType" to targetType)
        if (targetIds.isNotEmpty()) {
            params["targetIds"] = targetIds
        }
        return params
    }

    override fun getFilterQuery(): String {
        val filters = mutableListOf("post.structureType = 'room'")
        if (targetType == "community" && targetIds.isNotEmpty()) {
            val sanitizedIds = targetIds.map { it.replace("'", "''") }
            filters.add("post.targetType = 'community'")
            filters.add("post.targetId IN (${sanitizedIds.toSqlArray()})")
        }
        return filters.joinToString(separator = " AND ")
    }

    override fun optionalFilterQuery(): String {
        return getFilterQuery()
    }
}
