package com.amity.socialcloud.sdk.model.core.presence

import android.os.Parcelable
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityRoomPresence constructor(
    private val roomId: String,
    private val userPresences: List<AmityUserPresence>,
) : Parcelable {

    fun getRoomId(): String {
        return roomId
    }

    fun getUserPresences(): List<AmityUserPresence> {
        return userPresences
    }
}