package com.amity.socialcloud.sdk.model.core.file

import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize

@Parcelize
class AmityVideo(
    private val file: AmityRawFile
) : AmityFileInfo(file), AmityAttachment {

    fun getStatus(): String? {
        return (rawFile.getAttributes()?.get("status")?.asString)
    }

    fun getVideoUrl(resolution: AmityVideoResolution? = null): String? {
        return if (resolution == null) {
            getUrl()
        } else {
            (rawFile.getAttributes()?.get("videoUrl") as? JsonObject)?.get(resolution.apiKey)?.asString
        }
    }

    fun getResolutions(): List<AmityVideoResolution> {
        return ((rawFile.getAttributes()?.get("videoUrl") as? JsonObject)?.keySet()?.toList()
            ?: emptyList())
            .fold(mutableListOf()) { acc, res ->
                acc.apply {
                    AmityVideoResolution.enumOf(res)?.let(::add)
                }
            }
    }
    @ExperimentalAmityApi
    fun getMetadata(): JsonObject? {
        return rawFile.getMetaData()
    }

    enum class Quality(val apiString: String) {
        ORIGINAL("original"),
        HIGH("high"),
        MEDIUM("medium"),
        LOW("low");

        companion object {
            fun enumOf(apiKey: String?): Quality {
                return values().find { it.apiString == apiKey } ?: ORIGINAL
            }
        }
    }

    enum class Status(val apiString: String) {
        UPLOADED("uploaded"),
        TRANSCODING("transcoding"),
        TRANSCODED("transcoded"),
        TRANSCODE_FAILED("transcodeFailed");

        companion object {
            fun enumOf(apiKey: String?): Status {
                return values().find { it.apiString == apiKey } ?: UPLOADED
            }
        }
    }

    companion object {
        fun from(rawFile: AmityRawFile): AmityVideo? {
            return if (rawFile.getFileType() != AmityFileType.VIDEO) null else AmityVideo(rawFile)
        }
    }

}