package com.amity.socialcloud.sdk.core.engine.analytics

import com.amity.socialcloud.sdk.core.engine.analytics.capturer.AnalyticsEventCapturer
import com.amity.socialcloud.sdk.core.session.component.SessionComponent
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import kotlin.reflect.KClass

internal class AnalyticsEngine(
    sessionLifeCycleEventBus: SessionLifeCycleEventBus,
    sessionStateEventBus: SessionStateEventBus
) : SessionComponent(sessionLifeCycleEventBus, sessionStateEventBus) {

    private val eventCapturer = AnalyticsEventCapturer()
    private val eventSyncer = AnalyticsEventSyncer()

    fun getCapturerInstance() : AnalyticsEventCapturer? {
        if (sessionState === SessionState.Established || sessionState === SessionState.TokenExpired) {
            return eventCapturer
        } else {
            return null
        }
    }

    override fun onSessionStateChange(sessionState: SessionState) {
        // do nothing
    }

    override fun establish(account: EkoAccount) {
        eventSyncer.start()
    }

    override fun destroy() {
        eventSyncer.stop()
        eventSyncer.deleteAllAnalyticsEvents()
    }

    override fun handleTokenExpire() {
        eventSyncer.stop()
    }
}