package com.amity.socialcloud.sdk.chat.data.subchannel

import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewEntityMapper
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto
import io.reactivex.rxjava3.core.Completable

internal class SubChannelQueryPersister : QueryPersister<SubChannelListDto>() {

    override fun persist(dto: SubChannelListDto): Completable {
        return SubChannelLocalDataStore().saveSubChannels(SubChannelEntityMapper().map(dto.subChannels))
                .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
                .andThen(MessagePreviewRepository().saveMessagePreviews(MessagePreviewEntityMapper().let { mapper ->
                    val previews = mapper.mapSubChannelInfoToMessagePreview(dto.messages.map(mapper::toMesssagePreview), dto.subChannels.mapNotNull(mapper::toSubChannelInfo))
                    mapper.map(previews)
                }))
    }
}