package com.amity.socialcloud.sdk.api.social.post.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.internal.usecase.post.GetGlobalFeedV5PagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityCustomRankingGlobalFeedQuery internal constructor(
    private val dataTypes: List<AmityPost.DataType>,
    private val includeMixedStructure: Boolean
) {

    /**
     * Queries for custom ranking Global feed.
     * @return Flowable<PagingData<AmityPost>>.
     */
    fun query(): Flowable<PagingData<AmityPost>> {
        return GetGlobalFeedV5PagingDataUseCase().execute(
            dataTypes = dataTypes,
            includeMixedStructure = includeMixedStructure
        )
    }

    class Builder internal constructor(){
        // Not allow types filtering
        private var dataTypes: List<AmityPost.DataType> = listOf()
        private var includeMixedStructure: Boolean = false


        fun includeMixedStructure(includeMixedStructure: Boolean): Builder {
            return apply { this.includeMixedStructure = includeMixedStructure }
        }

        /**
         * Instantiates AmityCustomRankingGlobalFeedQuery with built params.
         * @return new instance of AmityCustomRankingGlobalFeedQuery.
         */
        fun build(): AmityCustomRankingGlobalFeedQuery {
            return AmityCustomRankingGlobalFeedQuery(
                dataTypes = dataTypes,
                includeMixedStructure = includeMixedStructure
            )
        }
    }

}