package com.amity.socialcloud.sdk.api.core.permission

import com.amity.socialcloud.sdk.model.core.permission.AmityPermission


class AmityPermissionValidator internal constructor(private val permission: AmityPermission) {

    fun atGlobal(): AmityGlobalPermissionValidator {
        return AmityGlobalPermissionValidator(permission = permission)
    }

    fun atChannel(channelId: String): AmityChannelPermissionValidator {
        return AmityChannelPermissionValidator(permission = permission, channelId = channelId)
    }

    fun atCommunity(communityId: String): AmityCommunityPermissionValidator {
        return AmityCommunityPermissionValidator(permission = permission, communityId = communityId)
    }
}