package com.amity.socialcloud.sdk.api.chat.notification

import com.amity.socialcloud.sdk.model.chat.notification.AmityChannelNotificationSettings
import com.amity.socialcloud.sdk.chat.domain.channel.notification.GetChannelNotificationUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.notification.SetAllowedNotificationUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single


class AmityChannelNotification internal constructor(private val channelId: String) {

    fun enable(): Completable {
        return SetAllowedNotificationUseCase().execute(channelId, true)
    }

    fun disable(): Completable {
        return SetAllowedNotificationUseCase().execute(channelId, false)
    }

    fun getSettings(): Single<AmityChannelNotificationSettings> {
        return GetChannelNotificationUseCase().execute(channelId)
    }

}