/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelTag;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0019\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\t\b\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H'J\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u008d\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\b\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H'\u00a2\u0006\u0002\u0010&Js\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\b\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010*\u001a\u00020\u0013H'J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0013H'J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u0013H\u0016J\u0014\u0010/\u001a\u0004\u0018\u00010\u00022\b\u00100\u001a\u0004\u0018\u00010\u0013H'J\u0010\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020\u0013J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H'J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010*\u001a\u00020\u00132\u0006\u00107\u001a\u00020%H'J\u0018\u00108\u001a\u0002062\u0006\u0010*\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u001aH'J\u0010\u0010:\u001a\u0002062\u0006\u0010*\u001a\u00020\u0013H'J\u0018\u0010;\u001a\u0002062\u0006\u0010*\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\"H'J\b\u0010=\u001a\u000206H'J\u0010\u0010>\u001a\u0002062\u0006\u0010*\u001a\u00020\u0013H'J\u0010\u0010?\u001a\u0002062\u0006\u0010*\u001a\u00020\u0013H\u0017J\u001c\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H'J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0012\u001a\u00020\u0013H'J\b\u0010B\u001a\u000206H\u0017J\u0010\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020\u0002H\u0002J\u0016\u0010C\u001a\u0002062\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0002J\u0010\u0010F\u001a\u0002062\u0006\u0010D\u001a\u00020\u0002H\u0017J\u0016\u0010F\u001a\u0002062\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0017J\u0010\u0010H\u001a\u0002062\u0006\u0010D\u001a\u00020\u0002H\u0017J\u0018\u0010I\u001a\u0002062\u0006\u0010*\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H'J\u0018\u0010J\u001a\u0002062\u0006\u0010*\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0013H'J\u0012\u0010L\u001a\u0004\u0018\u00010\u00132\u0006\u0010*\u001a\u00020\u0013H'J\u001e\u0010M\u001a\u0002062\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010!\u001a\u00020\"H'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/ekoapp/ekosdk/internal/EkoChannelEntity;", "Lcom/ekoapp/ekosdk/internal/data/dao/AmityPagingDao;", "Lcom/ekoapp/ekosdk/EkoChannelWithMembershipAndExtra;", "<init>", "()V", "channelMembershipDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelMembershipDao;", "messageDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoMessageDao;", "channelTagDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelTagDao;", "channelExtraDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoChannelExtraDao;", "getAllJoinedChannelsImpl", "Lio/reactivex/rxjava3/core/Flowable;", "", "userId", "", "membership", "getAllJoinedChannels", "getLatestChannelImpl", "types", "", "isFilterByMemberships", "", "memberships", "isIncludingTags", "includingTags", "isExcludingTags", "excludingTags", "isDeleted", "hash", "", "nonce", "now", "Lorg/joda/time/DateTime;", "([Ljava/lang/String;ZLjava/lang/String;[Ljava/lang/String;Z[Ljava/lang/String;Z[Ljava/lang/String;Ljava/lang/Boolean;IILorg/joda/time/DateTime;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestChannel", "([Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Boolean;IILorg/joda/time/DateTime;)Lio/reactivex/rxjava3/core/Flowable;", "getChannelImpl", "channelId", "getChannel", "getByIdNowImpl", "getByIdNow", "id", "getByInternalIdNowImpl", "internalId", "getByInternalIdNow", "getByIdsNowImpl", "ids", "getByIdsNow", "updateLastActivity", "", "lastActivity", "updateIsMuted", "isMuted", "notifyChanges", "updateMessageCount", "messageCount", "deleteAll", "deleteByIdImpl", "deleteById", "getActiveIds", "getInactiveIds", "deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading", "beforeInsertOrUpdate", "channel", "cs", "insert", "channels", "update", "updateMarkerHash", "updateMessagePreview", "messagePreviewId", "getMessagePreviewId", "notifyChannelsChanges", "channelIds", "amity-sdk_release"})
@Dao
public abstract class EkoChannelDao
extends EkoObjectDao<EkoChannelEntity>
implements AmityPagingDao<EkoChannelWithMembershipAndExtra> {
    @NotNull
    private final EkoChannelMembershipDao channelMembershipDao;
    @NotNull
    private final EkoMessageDao messageDao;
    @NotNull
    private final EkoChannelTagDao channelTagDao;
    @NotNull
    private final EkoChannelExtraDao channelExtraDao;

    public EkoChannelDao() {
        UserDatabase db = UserDatabase.get();
        EkoChannelMembershipDao ekoChannelMembershipDao = db.channelMembershipDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelMembershipDao, (String)"channelMembershipDao(...)");
        this.channelMembershipDao = ekoChannelMembershipDao;
        EkoMessageDao ekoMessageDao = db.messageDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoMessageDao, (String)"messageDao(...)");
        this.messageDao = ekoMessageDao;
        EkoChannelTagDao ekoChannelTagDao = db.channelTagDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelTagDao, (String)"channelTagDao(...)");
        this.channelTagDao = ekoChannelTagDao;
        EkoChannelExtraDao ekoChannelExtraDao = db.channelExtraDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoChannelExtraDao, (String)"channelExtraDao(...)");
        this.channelExtraDao = ekoChannelExtraDao;
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = :membership) and channel_membership.userId = :userId")
    @NotNull
    public abstract Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannelsImpl(@NotNull String var1, @NotNull String var2);

    @NotNull
    public final Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannels(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.getAllJoinedChannelsImpl(userId, AmityMembershipType.MEMBER.getApiKey());
    }

    @Query(value="SELECT * from channel where channel.channelType in (:types) and case when :isFilterByMemberships then channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) else channel.channelId is not null end and case when :isIncludingTags then channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) else channel.channelId is not null end and case when :isExcludingTags then channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) else channel.channelId is not null end and case when :isDeleted is not null then channel.isDeleted = :isDeleted else channel.channelId is not null end and channel.updatedAt > :now and channel.channelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by channel.updatedAt  desc limit 1")
    @NotNull
    public abstract Flowable<EkoChannelEntity> getLatestChannelImpl(@NotNull String[] var1, boolean var2, @NotNull String var3, @NotNull String[] var4, boolean var5, @NotNull String[] var6, boolean var7, @NotNull String[] var8, @Nullable Boolean var9, int var10, int var11, @NotNull DateTime var12);

    @NotNull
    public final Flowable<EkoChannelEntity> getLatestChannel(@NotNull String[] types, @NotNull String userId, @NotNull String[] memberships, @NotNull String[] includingTags, @NotNull String[] excludingTags, @Nullable Boolean isDeleted, int hash, int nonce, @NotNull DateTime now) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)memberships, (String)"memberships");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return this.getLatestChannelImpl(types, !(memberships.length == 0), userId, memberships, !(includingTags.length == 0), includingTags, !(excludingTags.length == 0), excludingTags, isDeleted, hash, nonce, now);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    @NotNull
    public abstract Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(@NotNull String var1);

    @NotNull
    public final Flowable<EkoChannelEntity> getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Flowable flowable = this.getChannelImpl(channelId).map((Function)getChannel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    @NotNull
    public abstract EkoChannelWithMembershipAndExtra getByIdNowImpl(@NotNull String var1);

    @Override
    @NotNull
    public EkoChannelEntity getByIdNow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT channel.* from channel where channel.internalChannelId = :internalId LIMIT 1")
    @Nullable
    public abstract EkoChannelEntity getByInternalIdNowImpl(@Nullable String var1);

    @Nullable
    public final EkoChannelEntity getByInternalIdNow(@NotNull String internalId) {
        Intrinsics.checkNotNullParameter((Object)internalId, (String)"internalId");
        return this.getByInternalIdNowImpl(internalId);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (:ids)")
    @NotNull
    public abstract List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    @NotNull
    public List<EkoChannelEntity> getByIdsNow(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        ImmutableList immutableList = FluentIterable.from((Iterable)this.getByIdsNowImpl(ids)).transform(arg_0 -> EkoChannelDao.getByIdsNow$lambda$1(EkoChannelDao::getByIdsNow$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toList(...)");
        return CollectionsKt.filterNotNull((Iterable)((Iterable)immutableList));
    }

    @Query(value="UPDATE channel set lastActivity = :lastActivity where channelId = :channelId")
    public abstract void updateLastActivity(@NotNull String var1, @NotNull DateTime var2);

    @Query(value="UPDATE channel set isMuted = :isMuted where channelId = :channelId")
    public abstract void updateIsMuted(@NotNull String var1, boolean var2);

    @Query(value="UPDATE channel set channelId = :channelId where channelId = :channelId")
    public abstract void notifyChanges(@NotNull String var1);

    @Query(value="UPDATE channel set messageCount = :messageCount where channelId = :channelId and messageCount < :messageCount")
    public abstract void updateMessageCount(@NotNull String var1, int var2);

    @Override
    @Query(value="DELETE from channel")
    public abstract void deleteAll();

    @Query(value="DELETE from channel where channelId = :channelId")
    public abstract void deleteByIdImpl(@NotNull String var1);

    @Transaction
    public void deleteById(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.deleteByIdImpl(channelId);
        this.messageDao.deleteAllFromChannel(channelId);
        this.channelMembershipDao.deleteAllFromChannel(channelId);
        this.channelExtraDao.deleteAllFromChannel(channelId);
    }

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = :userId)")
    @NotNull
    public abstract Flowable<List<String>> getActiveIds(@NotNull String var1);

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = :userId)")
    @NotNull
    public abstract List<String> getInactiveIds(@NotNull String var1);

    @Transaction
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        List<String> inactiveChannelIds = this.getInactiveIds(AmityCoreClient.INSTANCE.getUserId());
        for (String inactiveChannelId : inactiveChannelIds) {
            this.deleteById(inactiveChannelId);
        }
        this.channelExtraDao.updateAllReadStatuses(EkoChannelReadStatus.NOT_READING);
    }

    private final void beforeInsertOrUpdate(EkoChannelEntity channel) {
        EkoChannelEntity c = this.getByIdNow(channel.getChannelId());
        if (c != null) {
            channel.setMessageCount(Math.max(c.getMessageCount(), channel.getMessageCount()));
        }
    }

    private final void beforeInsertOrUpdate(List<? extends EkoChannelEntity> cs) {
        for (EkoChannelEntity ekoChannelEntity : cs) {
            this.beforeInsertOrUpdate(ekoChannelEntity);
        }
    }

    @Override
    @Transaction
    public void insert(@NotNull EkoChannelEntity channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.beforeInsertOrUpdate(channel);
        super.insert((EkoObject)channel);
        EkoTagDao.Companion.update(channel, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }

    @Override
    @Transaction
    public void insert(@NotNull List<? extends EkoChannelEntity> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        this.beforeInsertOrUpdate(channels);
        super.insert(channels);
        EkoTagDao.Companion.update(channels, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        ImmutableList immutableList = FluentIterable.from((Iterable)channels).transform(arg_0 -> EkoChannelDao.insert$lambda$3(EkoChannelDao::insert$lambda$2, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"toList(...)");
        this.channelExtraDao.insertOrUpdate(CollectionsKt.filterNotNull((Iterable)((Iterable)immutableList)));
    }

    @Override
    @Transaction
    public void update(@NotNull EkoChannelEntity channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.beforeInsertOrUpdate(channel);
        super.update((EkoObject)channel);
        EkoTagDao.Companion.update(channel, (EkoTagDao)this.channelTagDao, EkoChannelTag.Companion.getFactory());
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }

    @Query(value="UPDATE channel set channelMarkerHash = :hash where channelId = :channelId")
    public abstract void updateMarkerHash(@NotNull String var1, int var2);

    @Query(value="UPDATE channel set messagePreviewId = :messagePreviewId where channelId = :channelId")
    public abstract void updateMessagePreview(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT messagePreviewId FROM  channel WHERE channelId = :channelId LIMIT 1")
    @Nullable
    public abstract String getMessagePreviewId(@NotNull String var1);

    @Query(value="UPDATE channel set channelMarkerHash = :hash where channelId in (:channelIds)")
    public abstract void notifyChannelsChanges(@NotNull List<String> var1, int var2);

    private static final EkoChannelWithMembershipAndExtra getByIdsNow$lambda$0(EkoChannelWithMembershipAndExtra input) {
        return input;
    }

    private static final EkoChannelWithMembershipAndExtra getByIdsNow$lambda$1(Function1 $tmp0, Object p0) {
        return (EkoChannelWithMembershipAndExtra)$tmp0.invoke(p0);
    }

    private static final String insert$lambda$2(EkoChannelEntity channel) {
        EkoChannelEntity ekoChannelEntity = channel;
        return ekoChannelEntity != null ? ekoChannelEntity.getChannelId() : null;
    }

    private static final String insert$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

