/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.marker.subchannel;

import com.amity.socialcloud.sdk.chat.data.marker.reader.MarkReadRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ReCalculateChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.subchannel.GetSubChannelUnreadCountUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\u0012\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\b\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository;", "", "<init>", "()V", "fetchSubChannelMarker", "Lio/reactivex/rxjava3/core/Completable;", "subChannelIds", "", "", "getSubChannelMarker", "Lcom/ekoapp/ekosdk/internal/UserSubChannelMarkerEntity;", "subChannelId", "updateReadToSegment", "", "segment", "", "getUserSubChannelMarker", "startSubChannelReading", "readSubChannels", "stopSubChannelReading", "fetchSubChannelUnreadInfo", "channelIds", "getSubChannelUnreadInfo", "Lcom/ekoapp/ekosdk/internal/SubChannelUnreadInfoEntity;", "saveSubChannelUnreadInfo", "unreadInfo", "deleteUnreadInfoBySubChannelId", "deleteUnreadInfoByChannelId", "channelId", "deleteUnreadInfoCacheByChannelId", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubChannelMarkerRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubChannelMarkerRepository.kt\ncom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1563#2:109\n1634#2,3:110\n774#2:114\n865#2,2:115\n1563#2:117\n1634#2,3:118\n1869#2,2:121\n1#3:113\n*S KotlinDebug\n*F\n+ 1 SubChannelMarkerRepository.kt\ncom/amity/socialcloud/sdk/chat/data/marker/subchannel/SubChannelMarkerRepository\n*L\n84#1:109\n84#1:110,3\n87#1:114\n87#1:115,2\n90#1:117\n90#1:118,3\n92#1:121,2\n*E\n"})
public final class SubChannelMarkerRepository {
    @NotNull
    public final Completable fetchSubChannelMarker(@NotNull List<String> subChannelIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(subChannelIds, (String)"subChannelIds");
        if (!CoreClient.INSTANCE.isUnreadCountEnable() || subChannelIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            Completable completable3 = new SubChannelMarkerRemoteDataStore().querySubChannelMarkers(subChannelIds).flatMapCompletable((Function)fetchSubChannelMarker.1.INSTANCE);
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @Nullable
    public final UserSubChannelMarkerEntity getSubChannelMarker(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new GetSubChannelUnreadCountUseCase().execute(subChannelId);
    }

    public final void updateReadToSegment(@NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelMarkerLocalDataStore().updateReadToSegment(subChannelId, segment);
    }

    @Nullable
    public final UserSubChannelMarkerEntity getUserSubChannelMarker(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new SubChannelMarkerLocalDataStore().getUserSubChannelMarker(subChannelId);
    }

    @NotNull
    public final Completable startSubChannelReading(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = new MarkReadRemoteDataStore().startSubChannelReading(subChannelId).flatMapCompletable((Function)startSubChannelReading.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable readSubChannels(@NotNull List<String> subChannelIds) {
        Intrinsics.checkNotNullParameter(subChannelIds, (String)"subChannelIds");
        Completable completable = new MarkReadRemoteDataStore().readSubChannel(subChannelIds).flatMapCompletable((Function)readSubChannels.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable stopSubChannelReading(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = new MarkReadRemoteDataStore().stopSubChannelReading(subChannelId).flatMapCompletable((Function)stopSubChannelReading.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable fetchSubChannelUnreadInfo(@NotNull List<String> channelIds) {
        Completable completable;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        if (CoreClient.INSTANCE.isUnreadCountEnable()) {
            Completable completable2 = new SubChannelMarkerRemoteDataStore().queryUserSubChannelMarkers(channelIds).flatMapCompletable((Function)fetchSubChannelUnreadInfo.1.INSTANCE).subscribeOn(Schedulers.io());
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            Completable completable3 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @Nullable
    public final SubChannelUnreadInfoEntity getSubChannelUnreadInfo(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new SubChannelMarkerLocalDataStore().getSubChannelUnreadInfo(subChannelId);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSubChannelUnreadInfo(@NotNull List<? extends SubChannelUnreadInfoEntity> unreadInfo) {
        void $this$filterTo$iv$iv;
        SubChannelUnreadInfoEntity it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(unreadInfo, (String)"unreadInfo");
        Iterable $this$map$iv = unreadInfo;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SubChannelUnreadInfoEntity subChannelUnreadInfoEntity = (SubChannelUnreadInfoEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSubChannelId());
        }
        $this$map$iv = (List)destination$iv$iv;
        SubChannelMarkerLocalDataStore $i$f$map22 = new SubChannelMarkerLocalDataStore();
        Iterable p0 = $this$map$iv;
        boolean bl = false;
        List<String> deletedSubChannels = $i$f$map22.getDeletedSubChannelIds((List<String>)p0);
        Iterable $this$filter$iv = unreadInfo;
        boolean $i$f$filter22 = false;
        p0 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SubChannelUnreadInfoEntity)element$iv$iv;
            boolean bl2 = false;
            if (!(!deletedSubChannels.contains(it.getSubChannelId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        SubChannelMarkerLocalDataStore $i$f$filter22 = new SubChannelMarkerLocalDataStore();
        p0 = $this$filter$iv;
        boolean bl3 = false;
        $i$f$filter22.saveSubChannelUnreadInfo((List<? extends SubChannelUnreadInfoEntity>)p0);
        $this$map$iv = unreadInfo;
        boolean $i$f$map = false;
        p0 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SubChannelUnreadInfoEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it.getChannelId());
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String channelId = (String)element$iv;
            boolean bl5 = false;
            new ReCalculateChannelUnreadInfoUseCase().execute(channelId);
        }
    }

    public final void deleteUnreadInfoBySubChannelId(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        new SubChannelMarkerLocalDataStore().deleteUnreadInfoBySubChannelId(subChannelId);
    }

    public final void deleteUnreadInfoByChannelId(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        new SubChannelMarkerLocalDataStore().deleteUnreadInfoByChannelId(channelId);
    }

    public final void deleteUnreadInfoCacheByChannelId(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        new SubChannelMarkerLocalDataStore().deleteUnreadInfoCacheByChannelId(channelId);
    }
}

