/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core.presence;

import com.amity.socialcloud.sdk.core.presence.PresenceSyncEngine;
import com.ekoapp.ekosdk.internal.usecase.presence.DisablePresenceUseCase;
import com.ekoapp.ekosdk.internal.usecase.presence.EnablePresenceUseCase;
import com.ekoapp.ekosdk.internal.usecase.presence.GetPresenceUserSettingUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/api/core/presence/AmityPresenceService;", "", "presenceSyncEngine", "Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "<init>", "(Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;)V", "enable", "Lio/reactivex/rxjava3/core/Completable;", "disable", "isEnabled", "Lio/reactivex/rxjava3/core/Single;", "", "startHeartbeat", "stopHeartbeat", "", "startRoomHeartbeat", "roomId", "", "stopRoomHeartbeat", "amity-sdk_release"})
public final class AmityPresenceService {
    @Nullable
    private final PresenceSyncEngine presenceSyncEngine;

    public AmityPresenceService(@Nullable PresenceSyncEngine presenceSyncEngine) {
        this.presenceSyncEngine = presenceSyncEngine;
    }

    @NotNull
    public final Completable enable() {
        return new EnablePresenceUseCase().execute();
    }

    @NotNull
    public final Completable disable() {
        block0: {
            PresenceSyncEngine presenceSyncEngine = this.presenceSyncEngine;
            if (presenceSyncEngine == null) break block0;
            presenceSyncEngine.stopHeartbeat();
        }
        return new DisablePresenceUseCase().execute();
    }

    @NotNull
    public final Single<Boolean> isEnabled() {
        return new GetPresenceUserSettingUseCase().execute();
    }

    @NotNull
    public final Completable startHeartbeat() {
        PresenceSyncEngine presenceSyncEngine = this.presenceSyncEngine;
        if (presenceSyncEngine == null || (presenceSyncEngine = presenceSyncEngine.startHeartbeat()) == null) {
            Completable completable = Completable.never();
            presenceSyncEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never(...)");
        }
        return presenceSyncEngine;
    }

    public final void stopHeartbeat() {
        block0: {
            PresenceSyncEngine presenceSyncEngine = this.presenceSyncEngine;
            if (presenceSyncEngine == null) break block0;
            presenceSyncEngine.stopHeartbeat();
        }
    }

    @NotNull
    public final Completable startRoomHeartbeat(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        PresenceSyncEngine presenceSyncEngine = this.presenceSyncEngine;
        if (presenceSyncEngine == null || (presenceSyncEngine = presenceSyncEngine.startRoomHeartbeat(roomId)) == null) {
            Completable completable = Completable.never();
            presenceSyncEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never(...)");
        }
        return presenceSyncEngine;
    }

    public final void stopRoomHeartbeat() {
        block0: {
            PresenceSyncEngine presenceSyncEngine = this.presenceSyncEngine;
            if (presenceSyncEngine == null) break block0;
            presenceSyncEngine.stopRoomHeartbeat();
        }
    }
}

