package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.paging.SemanticSearchPostKeyCreator
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface AmitySemanticSearchPostPagingDao : DynamicQueryStreamPagingDao<PostEntity> {

    @RawQuery(observedEntities = [PostEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PostEntity>

    fun getSearchPostPagingSource(
        query: String,
        targetType: String?,
        targetId: String?,
        matchingOnlyParentPosts: Boolean,
        postTypes: List<AmityPost.DataType>,
        includeMixedStructure: Boolean,
    ): PagingSource<Int, PostEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "post",
                primaryKeyColumnName = "postId",
                additionalPrimaryKeys = emptyMap(),
                dynamicQueryStreamKeyCreator = SemanticSearchPostKeyCreator(
                    query = query,
                    targetType = targetType,
                    targetId = targetId,
                    matchingOnlyParentPosts = matchingOnlyParentPosts,
                    postTypes = postTypes,
                    includeMixedStructure = includeMixedStructure
                ),
                nonce = AmityNonce.SEMANTIC_SEARCH_POST_LIST,
                order = AmityPagingDao.Order.ASC
            )
        )
    }

}