package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.ekoapp.ekosdk.EkoFlag

class EkoFlagTypeConverter {
	@TypeConverter
	fun stringToEkoFlag(json: String?): EkoFlag? {
		return json?.let { EkoGson.get().fromJson(it, EkoFlag::class.java) }
	}
	
	@TypeConverter
	fun ekoFlagToString(flag: EkoFlag?): String? {
		return flag?.let(EkoGson.get()::toJson)
	}
}