/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity;
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse;
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus;
import com.amity.socialcloud.sdk.social.data.event.AmityEventResponseRepository;
import com.amity.socialcloud.sdk.social.data.event.EventResponseLocalDataStore;
import com.amity.socialcloud.sdk.social.data.event.EventResponseModelMapper;
import com.amity.socialcloud.sdk.social.data.event.paging.EventResponseQueryMediator;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/AmityEventResponseRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/social/event/EventResponseEntity;", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventResponse;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getEventResponsePagingData", "Landroidx/paging/PagingData;", "eventId", "status", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventResponseStatus;", "getLatestEventResponse", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "", "amity-sdk_release"})
public final class AmityEventResponseRepository
extends AmityObjectRepository<EventResponseEntity, AmityEventResponse> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = Completable.complete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        return completable;
    }

    @Override
    @Nullable
    public EventResponseEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventResponseLocalDataStore().getEventResponse(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EventResponseEntity, AmityEventResponse> mapper() {
        return new EventResponseModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EventResponseEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventResponseLocalDataStore().observe(objectId);
    }

    @NotNull
    public final Flowable<PagingData<AmityEventResponse>> getEventResponsePagingData(@NotNull String eventId, @Nullable AmityEventResponseStatus status) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, true, 10, 0, 0, 48, null), null, new EventResponseQueryMediator(eventId, status), () -> AmityEventResponseRepository.getEventResponsePagingData$lambda$0(eventId, status), new EventResponseModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<AmityEventResponse> getLatestEventResponse(@NotNull String eventId, @Nullable AmityEventResponseStatus status, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new EventResponseLocalDataStore().getLatestEventResponse(eventId, status, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestEventResponse.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    private static final PagingSource getEventResponsePagingData$lambda$0(String $eventId, AmityEventResponseStatus $status) {
        return new EventResponseLocalDataStore().getEventResponsePagingSource($eventId, $status);
    }
}

