package com.amity.socialcloud.sdk.social.data.category

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryListDto
import io.reactivex.rxjava3.core.Completable


internal class CategoryQueryPersister : QueryPersister<EkoCommunityCategoryListDto>() {

    override fun persist(dto: EkoCommunityCategoryListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(CategoryLocalDataStore().saveCategories(CategoryEntityMapper().map(dto.results)))
    }
}