package com.amity.socialcloud.sdk.core.data.room

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class RoomLocalDataStore {
    fun hasInLocal(roomId: String): Boolean {
        return UserDatabase.get().roomDao().getByIdNow(roomId) != null
    }

    fun saveRooms(rooms: List<RoomEntity>): Completable {
        return Completable.fromAction { if (rooms.isNotEmpty()) UserDatabase.get().roomDao().save(rooms) }
    }

    fun getRoom(roomId: String): RoomEntity? {
        var entity: RoomEntity? = null
        Completable.fromAction {
            entity = UserDatabase.get().roomDao().getByIdNow(roomId)
        }.subscribeOn(Schedulers.io()).blockingAwait()
        return entity
    }

    fun observeRoom(roomId: String): Flowable<RoomEntity> = UserDatabase.get().roomDao().getById(roomId)

    fun getRoomsByIds(roomIds: List<String>): List<RoomEntity> {
        var rooms: List<RoomEntity> = emptyList()
        Completable.fromAction {
            rooms = UserDatabase.get().roomDao().getByIdsNow(roomIds)
        }.subscribeOn(Schedulers.io()).blockingAwait()
        return rooms
    }

    fun hardDelete(roomId: String): Completable {
        return UserDatabase.get().roomDao().deleteById(roomId = roomId)
    }

    fun getRoomsPagingSource(
        statuses: List<String>,
        types: List<String>?,
        isDeleted: Boolean?,
        sortBy: String?
    ): PagingSource<Int, RoomEntity> = UserDatabase.get().roomPagingDao().queryRoomList(statuses, types, isDeleted, sortBy)

    fun getLatestRoom(statuses: List<String>): Flowable<RoomEntity> = UserDatabase.get().roomDao().getLatestRoom(statuses)

    fun notifyChanges(roomId: String) { UserDatabase.get().roomDao().updateRoom(roomId) }
}

