package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.core.data.room.RoomLocalDataStore
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.video.data.room.RoomModelMapper
import io.reactivex.rxjava3.core.Flowable

internal class LiveRoomPostQueryUseCase {

    fun execute(targetType: String, targetIds: List<String>): Flowable<List<AmityPost>> {
        val postRepository = PostRepository()
        val postComposerUseCase = PostComposerUseCase()

        return postRepository.getLiveRoomPosts(targetType, targetIds)
            .map { posts ->
                posts
                    .map(postComposerUseCase::execute)
                    .filter(::isLiveRoomPost)
            }
    }

    private fun isLiveRoomPost(post: AmityPost): Boolean {
        val roomLocalDataStore = RoomLocalDataStore()
        val roomModelMapper = RoomModelMapper()
        return post.getChildren()
            .firstOrNull()
            ?.getData()
            ?.let { it as? AmityPost.Data.ROOM }
            ?.getRoomId()
            ?.let(roomLocalDataStore::getRoom)
            ?.let(roomModelMapper::map)
            ?.getStatus()
            ?.let { it == AmityRoomStatus.LIVE }
            ?: false
    }
}
