package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.joda.time.DateTime

@Entity(tableName = "message_preview", primaryKeys = ["subChannelId"])
data class MessagePreviewEntity(
	val messagePreviewId: String,
	val dataType: String,
	val data: JsonObject?,
	val channelId: String,
	val subChannelId: String,
	var subChannelName: String? = null,
	var subChannelUpdatedAt: DateTime? = null,
	val creatorId: String,
	val isDeleted: Boolean,
	val segment: Int
) : EkoObject() {
	override fun getId(): String {
		return subChannelId
	}
	
	override fun equals(other: Any?): Boolean {
		if (other == null) return false
		if (other === this) return true
		return (other is MessagePreviewEntity
				&& Objects.equal(messagePreviewId, other.messagePreviewId)
				&& Objects.equal(dataType, other.dataType)
				&& Objects.equal(data, other.data)
				&& Objects.equal(channelId, other.channelId)
				&& Objects.equal(subChannelId, other.subChannelId)
				&& Objects.equal(subChannelName, other.subChannelName)
				&& Objects.equal(subChannelUpdatedAt, other.subChannelUpdatedAt)
				&& Objects.equal(creatorId, other.creatorId)
				&& Objects.equal(isDeleted, other.isDeleted)
				&& Objects.equal(segment, other.segment)
				&& Objects.equal(createdAt, other.createdAt)
				&& Objects.equal(updatedAt, other.updatedAt)
				)
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				messagePreviewId,
				dataType,
				data,
				channelId,
				subChannelId,
				subChannelName,
				subChannelUpdatedAt,
				creatorId,
				isDeleted,
				segment,
				createdAt,
				updatedAt
		)
	}
}