package com.amity.socialcloud.sdk.social.data.event.paging

import com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventSortOption
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus
import com.amity.socialcloud.sdk.model.social.event.AmityEventType
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class EventQueryKeyCreator(
    private val originType: AmityEventOriginType?,
    private val originId: String?,
    private val userId: String?,
    private val status: AmityEventStatus?,
    private val type: AmityEventType?,
    private val onlyAttendee: Boolean?,
    private val sortBy: AmityEventSortOption,
    private val orderBy: AmityEventOrderOption
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        val map = mutableMapOf<String, Any>()
        
        originType?.let { map["originType"] = it.apiKey }
        originId?.let { map["originId"] = it }
        userId?.let { map["userId"] = it }
        status?.let { map["status"] = it.apiKey }
        type?.let { map["type"] = it.apiKey }
        onlyAttendee?.let { map["onlyAttendee"] = it }
        map["sortBy"] = sortBy.value
        map["orderBy"] = orderBy.value
        
        return map
    }

    override fun getFilterQuery(): String {
        val filters = mutableListOf<String>()
        
        originType?.let { 
            filters.add("originType = '${it.apiKey}'") 
        }
        originId?.let { 
            filters.add("originId = '$it'") 
        }
//        userId?.let {
//            filters.add("userId = '$it'")
//        }
        status?.let { 
            filters.add("status = '${it.apiKey}'") 
        }
        type?.let { 
            filters.add("type = '${it.apiKey}'")
        }
        
        // onlyAttendee filter: check if current user has an RSVP for this event
//        if (onlyAttendee == true) {
//            val currentUserId = SessionLocalDataStore().getActiveUserId()
//            filters.add("eventId IN (SELECT eventId FROM event_response WHERE userId = '$currentUserId')")
//        }
        
        return if (filters.isNotEmpty()) {
            filters.joinToString(" AND ")
        } else {
            "1=1"
        }
    }
}
