package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponse
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus
import com.amity.socialcloud.sdk.social.domain.event.EventComposerUseCase

internal class EventResponseModelMapper : ModelMapper<EventResponseEntity, AmityEventResponse>() {

    override fun map(entity: EventResponseEntity): AmityEventResponse {
        val response = AmityEventResponse(
            rsvpId = entity.rsvpId,
            status = AmityEventResponseStatus.enumOf(entity.status),
            eventId = entity.eventId,
            event = null,
            userId = entity.userId,
            user = null,
            createdAt = entity.createdAt,
            respondedAt = entity.respondedAt,
            updatedAt = entity.updatedAt
        )
        
        // Compose linked objects from local database
        composeLinkedObjects(response)
        
        return response
    }
    
    private fun composeLinkedObjects(response: AmityEventResponse) {
        // Add linked user
        response.user = UserGetUseCase().execute(response.getUserId())
        
        // Add linked event
        val eventEntity = EventLocalDataStore().getEvent(response.getEventId())
        eventEntity?.let {
            val event = EventModelMapper().map(it)
            // Compose the event with its linked objects (creator, cover image, target community)
            EventComposerUseCase().execute(event)
            response.event = event
        }
    }
}
