/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserSubChannelMarkerDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class UserSubChannelMarkerDao_Impl
extends UserSubChannelMarkerDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<UserSubChannelMarkerEntity> __insertAdapterOfUserSubChannelMarkerEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<UserSubChannelMarkerEntity> __deleteAdapterOfUserSubChannelMarkerEntity;
    private final EntityDeleteOrUpdateAdapter<UserSubChannelMarkerEntity> __updateAdapterOfUserSubChannelMarkerEntity;

    public UserSubChannelMarkerDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfUserSubChannelMarkerEntity = new EntityInsertAdapter<UserSubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_sub_channel_marker` (`subChannelId`,`channelId`,`userId`,`unreadCount`,`readToSegment`,`deliveredToSegment`,`hasMentioned`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                statement.bindLong(4, (long)entity.getUnreadCount());
                statement.bindLong(5, (long)entity.getReadToSegment());
                statement.bindLong(6, (long)entity.getDeliveredToSegment());
                int _tmp = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                String _tmp_1 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                String _tmp_2 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfUserSubChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<UserSubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_sub_channel_marker` WHERE `subChannelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserSubChannelMarkerEntity = new EntityDeleteOrUpdateAdapter<UserSubChannelMarkerEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_sub_channel_marker` SET `subChannelId` = ?,`channelId` = ?,`userId` = ?,`unreadCount` = ?,`readToSegment` = ?,`deliveredToSegment` = ?,`hasMentioned` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSubChannelMarkerEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                statement.bindLong(4, (long)entity.getUnreadCount());
                statement.bindLong(5, (long)entity.getReadToSegment());
                statement.bindLong(6, (long)entity.getDeliveredToSegment());
                int _tmp = entity.getHasMentioned() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                String _tmp_1 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                String _tmp_2 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = UserSubChannelMarkerDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getSubChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(UserSubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserSubChannelMarkerEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends UserSubChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserSubChannelMarkerEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(UserSubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserSubChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends UserSubChannelMarkerEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserSubChannelMarkerEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(UserSubChannelMarkerEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfUserSubChannelMarkerEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(UserSubChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSubChannelMarkerDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends UserSubChannelMarkerEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSubChannelMarkerDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(UserSubChannelMarkerEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSubChannelMarkerDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public UserSubChannelMarkerEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1";
        return (UserSubChannelMarkerEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1");){
                UserSubChannelMarkerEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfDeliveredToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deliveredToSegment");
                int _columnIndexOfHasMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new UserSubChannelMarkerEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpDeliveredToSegment = (int)_stmt.getLong(_columnIndexOfDeliveredToSegment);
                    _result.setDeliveredToSegment(_tmpDeliveredToSegment);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfHasMentioned);
                    boolean _tmpHasMentioned = _tmp != 0;
                    _result.setHasMentioned(_tmpHasMentioned);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserSubChannelMarkerEntity userSubChannelMarkerEntity = _result;
                return userSubChannelMarkerEntity;
            }
        });
    }

    @Override
    public Flowable<UserSubChannelMarkerEntity> getById(String subChannelId) {
        String _sql = "SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_sub_channel_marker"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_sub_channel_marker where subChannelId = ? LIMIT 1");){
                UserSubChannelMarkerEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfDeliveredToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deliveredToSegment");
                int _columnIndexOfHasMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasMentioned");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new UserSubChannelMarkerEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpDeliveredToSegment = (int)_stmt.getLong(_columnIndexOfDeliveredToSegment);
                    _result.setDeliveredToSegment(_tmpDeliveredToSegment);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfHasMentioned);
                    boolean _tmpHasMentioned = _tmp != 0;
                    _result.setHasMentioned(_tmpHasMentioned);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserSubChannelMarkerEntity userSubChannelMarkerEntity = _result;
                return userSubChannelMarkerEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_sub_channel_marker";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_sub_channel_marker");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String subChannelId) {
        String _sql = "DELETE from user_sub_channel_marker where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_sub_channel_marker where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateReadToSegment(String subChannelId, int segment) {
        String _sql = "UPDATE user_sub_channel_marker set readToSegment = ? where subChannelId = ? and readToSegment < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_sub_channel_marker set readToSegment = ? where subChannelId = ? and readToSegment < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)segment);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)segment);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void deleteByChannelId(String channelId) {
        String _sql = "DELETE from user_sub_channel_marker where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_sub_channel_marker where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

