/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.InvitationDao;
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class InvitationDao_Impl
extends InvitationDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<InvitationEntity> __insertAdapterOfInvitationEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<InvitationEntity> __deleteAdapterOfInvitationEntity;
    private final EntityDeleteOrUpdateAdapter<InvitationEntity> __updateAdapterOfInvitationEntity;

    public InvitationDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfInvitationEntity = new EntityInsertAdapter<InvitationEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `invitation` (`invitationId`,`type`,`targetId`,`targetType`,`invitedUserId`,`inviterUserId`,`status`,`communityId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull InvitationEntity entity) {
                if (entity.getInvitationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getInvitationId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetType());
                }
                if (entity.getInvitedUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getInvitedUserId());
                }
                if (entity.getInviterUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getInviterUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getCommunityId());
                }
                String _tmp = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                String _tmp_1 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                String _tmp_2 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfInvitationEntity = new EntityDeleteOrUpdateAdapter<InvitationEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `invitation` WHERE `invitationId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull InvitationEntity entity) {
                if (entity.getInvitationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getInvitationId());
                }
            }
        };
        this.__updateAdapterOfInvitationEntity = new EntityDeleteOrUpdateAdapter<InvitationEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `invitation` SET `invitationId` = ?,`type` = ?,`targetId` = ?,`targetType` = ?,`invitedUserId` = ?,`inviterUserId` = ?,`status` = ?,`communityId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `invitationId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull InvitationEntity entity) {
                if (entity.getInvitationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getInvitationId());
                }
                if (entity.getType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetType());
                }
                if (entity.getInvitedUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getInvitedUserId());
                }
                if (entity.getInviterUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getInviterUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getCommunityId());
                }
                String _tmp = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                String _tmp_1 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                String _tmp_2 = InvitationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_2);
                }
                if (entity.getInvitationId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getInvitationId());
                }
            }
        };
    }

    @Override
    public void insertImpl(InvitationEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfInvitationEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends InvitationEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfInvitationEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends InvitationEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfInvitationEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(InvitationEntity invitation) {
        if (invitation == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfInvitationEntity.handle(_connection, (Object)invitation);
            return null;
        });
    }

    @Override
    public void updateImpl(InvitationEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfInvitationEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(InvitationEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            InvitationDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends InvitationEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            InvitationDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(InvitationEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            InvitationDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public InvitationEntity getInvitation(String targetId) {
        String _sql = "SELECT * FROM invitation WHERE targetId = ?";
        return (InvitationEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM invitation WHERE targetId = ?");){
                InvitationEntity _result;
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                int _columnIndexOfInvitationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitationId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfInvitedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitedUserId");
                int _columnIndexOfInviterUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"inviterUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpInvitationId = _stmt.isNull(_columnIndexOfInvitationId) ? null : _stmt.getText(_columnIndexOfInvitationId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpInvitedUserId = _stmt.isNull(_columnIndexOfInvitedUserId) ? null : _stmt.getText(_columnIndexOfInvitedUserId);
                    String _tmpInviterUserId = _stmt.isNull(_columnIndexOfInviterUserId) ? null : _stmt.getText(_columnIndexOfInviterUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result = new InvitationEntity(_tmpInvitationId, _tmpType, _tmpTargetId, _tmpTargetType, _tmpInvitedUserId, _tmpInviterUserId, _tmpStatus, _tmpCommunityId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                InvitationEntity invitationEntity = _result;
                return invitationEntity;
            }
        });
    }

    @Override
    public Flowable<InvitationEntity> observeUserInvitation(String targetId, String targetType, String invitedUserId) {
        String _sql = "SELECT * FROM invitation WHERE targetId = ? and targetType = ? and invitedUserId = ? order by createdAt desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"invitation"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM invitation WHERE targetId = ? and targetType = ? and invitedUserId = ? order by createdAt desc limit 1");){
                InvitationEntity _result;
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 3;
                if (invitedUserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, invitedUserId);
                }
                int _columnIndexOfInvitationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitationId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfInvitedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitedUserId");
                int _columnIndexOfInviterUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"inviterUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpInvitationId = _stmt.isNull(_columnIndexOfInvitationId) ? null : _stmt.getText(_columnIndexOfInvitationId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpInvitedUserId = _stmt.isNull(_columnIndexOfInvitedUserId) ? null : _stmt.getText(_columnIndexOfInvitedUserId);
                    String _tmpInviterUserId = _stmt.isNull(_columnIndexOfInviterUserId) ? null : _stmt.getText(_columnIndexOfInviterUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result = new InvitationEntity(_tmpInvitationId, _tmpType, _tmpTargetId, _tmpTargetType, _tmpInvitedUserId, _tmpInviterUserId, _tmpStatus, _tmpCommunityId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                InvitationEntity invitationEntity = _result;
                return invitationEntity;
            }
        });
    }

    @Override
    public Flowable<List<InvitationEntity>> observeInvitations(String targetId, String targetType) {
        String _sql = "SELECT * FROM invitation WHERE targetId = ? and targetType = ? order by createdAt desc";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"invitation"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM invitation WHERE targetId = ? and targetType = ? order by createdAt desc");){
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                int _columnIndexOfInvitationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitationId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfInvitedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitedUserId");
                int _columnIndexOfInviterUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"inviterUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<InvitationEntity> _result = new ArrayList<InvitationEntity>();
                while (_stmt.step()) {
                    String _tmpInvitationId = _stmt.isNull(_columnIndexOfInvitationId) ? null : _stmt.getText(_columnIndexOfInvitationId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpInvitedUserId = _stmt.isNull(_columnIndexOfInvitedUserId) ? null : _stmt.getText(_columnIndexOfInvitedUserId);
                    String _tmpInviterUserId = _stmt.isNull(_columnIndexOfInviterUserId) ? null : _stmt.getText(_columnIndexOfInviterUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    InvitationEntity _item = new InvitationEntity(_tmpInvitationId, _tmpType, _tmpTargetId, _tmpTargetType, _tmpInvitedUserId, _tmpInviterUserId, _tmpStatus, _tmpCommunityId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<InvitationEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public InvitationEntity getByIdNowImpl(String invitationId) {
        String _sql = "SELECT * FROM invitation WHERE invitationId = ? LIMIT 1";
        return (InvitationEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM invitation WHERE invitationId = ? LIMIT 1");){
                InvitationEntity _result;
                int _argIndex = 1;
                if (invitationId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, invitationId);
                }
                int _columnIndexOfInvitationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitationId");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfInvitedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"invitedUserId");
                int _columnIndexOfInviterUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"inviterUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpInvitationId = _stmt.isNull(_columnIndexOfInvitationId) ? null : _stmt.getText(_columnIndexOfInvitationId);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpInvitedUserId = _stmt.isNull(_columnIndexOfInvitedUserId) ? null : _stmt.getText(_columnIndexOfInvitedUserId);
                    String _tmpInviterUserId = _stmt.isNull(_columnIndexOfInviterUserId) ? null : _stmt.getText(_columnIndexOfInviterUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result = new InvitationEntity(_tmpInvitationId, _tmpType, _tmpTargetId, _tmpTargetType, _tmpInvitedUserId, _tmpInviterUserId, _tmpStatus, _tmpCommunityId);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                InvitationEntity invitationEntity = _result;
                return invitationEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from invitation";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from invitation");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public int updateStatus(String invitationId, String status) {
        String _sql = "UPDATE invitation SET status = ? WHERE invitationId = ?";
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE invitation SET status = ? WHERE invitationId = ?");){
                int _argIndex = 1;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 2;
                if (invitationId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, invitationId);
                }
                _stmt.step();
                Integer n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
                return n;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

