package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreatePostV4UseCase {

    fun execute(
        targetType: String,
        targetId: String,
        data: JsonObject,
        dataType: AmityPost.DataType? = null,
        attachments: List<AmityPostAttachment>?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = data,
            dataType = dataType,
            attachments = attachments,
            metadata = metadata,
            mentionees = mentionees
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(AmityException.create("Post not found", null, AmityError.ITEM_NOT_FOUND))
            }
        }
    }
}